#include <stdio.h>
#include <math.h>

#ifndef _NO_PROTO
double              Xmgfsinc(double x);
double              Xmgfcosc(double x);
#else
double              Xmgfsinc();
double              Xmgfcosc();
#endif

int 
main(argc, argv)
int                 argc;
char              **argv;
{
  FILE               *fp;
  char                filename[100];
  double              sx, sy, ex, ey;
  double              stepx, stepy;
  double              gray;
  double              u, v;

 /* test on input parameters */
  if (argc < 8) {
    fprintf(stderr,
      "Usage: CreateSinc sx ex stepx sy ey stepy <out_filename>\n");
    exit(-1);
  }
 /* read in parameters */
  sscanf(argv[1], "%lf", &sx);
  sscanf(argv[2], "%lf", &ex);
  sscanf(argv[3], "%lf", &stepx);
  sscanf(argv[4], "%lf", &sy);
  sscanf(argv[5], "%lf", &ey);
  sscanf(argv[6], "%lf", &stepy);
  sscanf(argv[7], "%s", filename);

 /* test on output file */
  if (NULL == (fp = fopen(filename, "w"))) {
    fprintf(stderr, "Errors in %s\n", filename);
    exit(-1);
  }
 /* open data set */
/*  fprintf(fp, "@Set SincFunc\nFormat Point3D\n");*/
  fprintf(fp, "%d %d\n",(int)((ex-sx)/stepx),(int)((ey-sy)/stepy));

 /* create data set */
  for (u = sx; u <= ex; u += stepx)
    for (v = sy; v <= ey; v += stepy) {
      gray = 10*(Xmgfsinc(u) * Xmgfsinc(v));
      fprintf(fp, "%lf\t%lf\t%lf\n", u, v, gray);
    }

 /* close data set */
/*  fprintf(fp, "@\n");*/
  fprintf(fp, "@\n");

  fclose(fp);

  return 0;
}


double 
Xmgfsinc(x)
double x;
{
  if (0 == x)
    return (1.0);
  else
    return (sin(x) / x);
}

double
cosc(x)
double x;
{
  if (0 == x)
    return (1.0);
  else
    return (cos(x) / x);
}

