/********************************************************************\
 * messages.h -- english-language messages for xacc (X-Accountant   *
 * Copyright (C) 1997 Robin D. Clark                                *
 * Copyright (C) 1997, 1998 Linas Vepstas                           *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
 *   Author: Rob Clark                                              *
 * Internet: rclark@cs.hmc.edu                                      *
 *  Address: 609 8th Street                                         *
 *           Huntington Beach, CA 92648-4632                        *
\********************************************************************/

#ifndef __XACC_MESSAGES_H__
#define __XACC_MESSAGES_H__

#include "config.h"

/** DIALOG BOX MESSAGES: ********************************************/
#define ACC_NEW_MSG       "Do you want to create a new account?\n"\
                          "If not, then please select an account\n"\
                          "to open in the main window.\n"
#define ACC_EDIT_MSG      "To edit an account, you must first \n"\
                          "choose an account to delete.\n"
#define ACC_DEL_MSG       "To delete an account, you must first \n"\
                          "choose an account to delete.\n"
#define ACC_DEL_SURE_MSG  "Are you sure you want to delete the %s account?"
#define ACC_NO_NAME_MSG   "The account must be given a name! \n"
#define FILE_TOO_OLD_MSG  "This file is from an older version of "\
                          "X-Accountant.  Do you want to continue?"
#define FILE_TOO_NEW_MSG  "This file appears to be from a newer version "\
                          "of X-Accountant.  Do you want to continue?"
#define FILE_BAD_READ_MSG "There was an error reading the file. "\
                          "Do you want to continue?"
#define FILE_NOT_FOUND_MSG "The file %s could not be found."
#define FILE_EMPTY_MSG    "The file %s is empty."
#define FMB_SAVE_MSG      "Changes have been made since last "\
                          "Save.  Save data to file?"
#define RECN_TRANS_WARN   "Warning!  This is a reconciled transaction. "\
                          "Do you want do continue?"
#define TRANS_DEL_MSG     "Are you sure you want to delete\n   %s\n"\
                          "from the transaction\n   %s ?"

#define XFER_NSF_MSG      "There must be at least two accounts\n"\
                          "created before you can transfer funds."
#define XFER_DIFF_MSG     "The \"From\" and \"To\" accounts\n must be different!"
#define XFER_SAME_MSG     "You can't transfer from and to the same account!"
#define XFER_NO_ACC_MSG   "You must specify an account to transfer from, \n"\
                          "or to, or both, for this transaction; otherise \n"\
                          "it will not be recorded."


/* Tooltip phrases */
#define TOOLTIP_OPEN	"Open an account."
#define TOOLTIP_NEW	"Create a new account."
#define TOOLTIP_EDIT	"Edit selected account."
#define TOOLTIP_DELETE	"Delete selected account."
#define TOOLTIP_EXIT	"Exit Xacc."
			  
/** MISC INTERNATIONALIZATION STRINGS: ******************************/
/* hack alert -- Linux seems not to support localeconv()
 * for getting currency symbols & monetary units.  Besides,
 * I couldn't find a routine that would print currency amounts anyway... 
 */

/* hack alert -- probably, most of these should be handled as
 * X resources, instead of compile-time things */

#define CURRENCY_SYMBOL  "$"

/* phrases */
#define ACC_CODE_STR     "Account Code"
#define ACC_NAME_STR     "Account Name"
#define ACC_TYPE_STR     "Account Type"
#define ADJ_BALN_STR     "Adjust Balance"
#define CLOSE_WIN_STR    "Close Window"
#define CREDIT_CARD_STR  "Credit Card"
#define CREDITLINE_STR   "Credit Line"         /* Line of Credit */
#define DEL_ACC_STR      "Delete Account"
#define DEL_TRANS_STR    "Delete Transaction"
#define EDIT_ACCT_STR    "Edit Account"
#define END_BALN_STR     "Ending Balance"
#define IMPORT_QIF_STR   "Import QIF"
#define LOST_ACC_STR     "Lost Accounts"
#define MONEYMRKT_STR    "Money Market"
#define MUTUAL_FUND_STR  "Mutual Fund"
#define NEW_ACC_STR      "New Account"
#define NEW_BALN_STR     "New Balance"
#define NEW_FILE_STR     "New File"
#define OPEN_ACC_STR     "Open Account"
#define OPEN_BALN_STR    "Opening Balance"
#define OPEN_FILE_STR    "Open File"
#define OPEN_SUB_STR     "Open Subaccounts"
#define PICK_ONE_STR     "Pick One"
#define PARENT_ACC_STR   "Parent Account"
#define PREV_BALN_STR    "Previous Balance"
#define PURCH_PRIC_STR   "Purch Price"
#define SALE_PRIC_STR    "Sale Price"
#define SAVE_AS_STR      "Save As"
#define SETUP_ACCT_STR   "Set Up Account"
#define TOT_SHRS_STR     "Tot Shrs"
#define XFER_MONEY_STR   "Transfer Money"
#define XFRM_STR         "Transfer From"
#define XFTO_STR         "Transfer To"

/* single words */
#define ABOUT_STR        "About"
#define ACCOUNT_STR      "Account"
#define ACCOUNTS_STR     "Accounts"
#define ACH_STR          "AutoDep"   /* Automatic Check Handling auto deposit */
#define ACTION_STR       "Action"
#define ACTIVITIES_STR   "Activities"
#define AMT_STR          "Amount"
#define APPR_STR         "Appreciation"
#define ARU_STR          "Phone"   /* Automated Response Unit telephone xfer */
#define ASSET_STR        "Asset"
#define ASSETS_STR       "Assets"
#define ATM_STR          "ATM"          /* automatic teller machine */
#define BACK_STR         "Back"
#define BALN_STR         "Balance"
#define BANK_STR         "Bank"
#define BOUGHT_STR       "Bought"
#define BUY_STR          "Buy"
#define CANCEL_STR       "Cancel"
#define CASH_STR         "Cash"
#define CHARGE_STR       "Charge"
#define CHECK_STR        "Check"
#define CHECKING_STR     "Checking"
#define CLEARED_STR      "Cleared"
#define CLOSE_STR        "Close"
#define CREATE_STR       "Create"
#define CREDIT_STR       "Credit"
#define CREDITS_STR      "Credits"
#define CURRENCY_STR     "Currency"
#define DATE_STR         "Date"
#define DEBIT_STR        "Debit"
#define DEBITS_STR       "Debits"
#define DECREASE_STR     "Decrease"
#define DEFICIT_STR      "Deficit"
#define DELETE_STR       "Delete"
#define DEPOSIT_STR      "Deposit"
#define DEPR_STR         "Depreciation"
#define DESC_STR         "Description"
#define DIFF_STR         "Difference"
#define DIST_STR         "Dist"    /* Distribution */
#define DIV_STR          "Div"     /* Dividend */
#define EDIT_STR         "Edit"
#define EQUITY_STR       "Equity"
#define EXPENSE_STR      "Expense"
#define FILE_STR         "File"
#define FORWARD_STR      "Forward"
#define FROM_STR         "From"
#define HELP_STR         "Help"
#define INCOME_STR       "Income"
#define INCREASE_STR     "Increase"
#define INT_STR          "Int"     /* Interest */
#define LIABILITY_STR    "Liability"
#define LICENSE_STR      "License"
#define LOAN_STR         "Loan"   
#define LTCG_STR         "LTCG"    /* Long Term Capital Gains */
#define MEMO_STR         "Memo"
#define NEW_STR          "New"
#define NO_STR           "No"
#define NONE_STR         "(none)"
#define NOTES_STR        "Notes"
#define NUM_STR          "Num"
#define OK_STR           "Ok"
#define ONLINE_STR       "Online"
#define OPEN_STR         "Open"
#define PAYMENT_STR      "Payment"
#define POS_STR          "POS"       /* Point of Sale credit card machine */
#define PRICE_STR        "Price"
#define PROFITS_STR      "Profits"
#define QUIT_STR         "Quit"
#define REBATE_STR       "Rebate"
#define RECEIVE_STR      "Receive"
#define RECONCILE_STR    "Reconcile"
#define RECORD_STR       "Record"
#define REPORT_STR       "Report"
#define SAVE_STR         "Save"
#define SAVINGS_STR      "Savings"
#define SECURITY_STR     "Security"
#define SELL_STR         "Sell"
#define SIMPLE_STR       "Simple"
#define SOLD_STR         "Sold"
#define SPEND_STR        "Spend"
#define SPLIT_STR        "Split"
#define STCG_STR         "STCG"   /* Short Term Captial Gains */
#define STOCK_STR        "Stock"  
#define SURPLUS_STR      "Surplus"
#define TELLER_STR       "Teller"
#define TO_STR           "To"
#define TOTAL_STR        "Total"
#define TRANSFER_STR     "Transfer"
#define VALUE_STR        "Value"
#define WARN_STR         "WARNING"
#define WIRE_STR         "Wire"         /* Electronic Wire transfer */
#define WITHDRAW_STR     "Withdraw"
#define YES_STR          "Yes"

/* with colons at end */
#define ACC_CODE_C_STR   ACC_CODE_STR   ":"
#define ACC_NAME_C_STR   ACC_NAME_STR   ":"
#define ASSETS_C_STR     ASSETS_STR     ":"
#define BALN_C_STR       BALN_STR       ":"
#define CLEARED_C_STR    CLEARED_STR    ":"
#define CREDITS_C_STR    CREDITS_STR    ":"
#define CURRENCY_C_STR   CURRENCY_STR   ":"
#define DEBITS_C_STR     DEBITS_STR     ":"
#define DESC_C_STR       DESC_STR       ":"
#define DIFF_C_STR       DIFF_STR       ":"
#define END_BALN_C_STR   END_BALN_STR   ":"
#define FROM_C_STR       FROM_STR       ":"
#define PARENT_ACC_C_STR PARENT_ACC_STR ":"
#define PREV_BALN_C_STR  PREV_BALN_STR  ":"
#define PROFITS_C_STR    PROFITS_STR    ":"
#define SECURITY_C_STR   SECURITY_STR   ":"
#define TO_C_STR         TO_STR         ":"
#define TOTAL_C_STR      TOTAL_STR      ":"

/* with elipses at end (for menu items) */
#define ABOUT_E_STR      ABOUT_STR      "..."
#define ACCOUNTS_E_STR   ACCOUNTS_STR   "..."
#define ADJ_BALN_E_STR   ADJ_BALN_STR   "..."
#define DEL_ACC_E_STR    DEL_ACC_STR    "..."
#define EDIT_ACCT_E_STR  EDIT_ACCT_STR  "..."
#define HELP_E_STR       HELP_STR       "..."
#define IMPORT_QIF_E_STR IMPORT_QIF_STR "..."
#define LICENSE_E_STR    LICENSE_STR    "..."
#define NEW_ACC_E_STR    NEW_ACC_STR    "..."
#define NEW_FILE_E_STR   NEW_FILE_STR   "..."
#define OPEN_ACC_E_STR   OPEN_ACC_STR   "..."
#define OPEN_FILE_E_STR  OPEN_FILE_STR  "..."
#define RECONCILE_E_STR  RECONCILE_STR  "..."
#define REPORT_E_STR     REPORT_STR     "..."
#define SAVE_E_STR       SAVE_STR       "..."
#define SAVE_AS_E_STR    SAVE_AS_STR    "..."
#define SIMPLE_E_STR     SIMPLE_STR     "..."
#define TRANSFER_E_STR   TRANSFER_STR   "..."

#endif /* __XACC_MESSAGES_H__ */
