/*

  A really stupid little app that will actually let you enter
  multi-line splits.

*/


#include <stdlib.h>
#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <assert.h>

#include <FileIO.h>
#include <Group.h>
#include <Account.h>
#include <Transaction.h>
#include <date.h>

static Account *
select_account(AccountGroup *ag, const char prompt[], const int all_accounts) {
  const int num_accts = xaccGetNumAccounts(ag);
  Account *result = NULL;
  int menu_needed = 1;
  int done = 0;
  while(!done) {
    char *input = NULL;
    if(menu_needed) {
      int i;
      for(i = 0; i < num_accts; i++) {
        Account *acct = xaccGetAccountFromID(ag, i);
        if(acct) {
          if(all_accounts) {
            printf("  %4d: %s\n", i, xaccAccountGetName(acct));
          } else if(xaccAccountGetType(acct) != EXPENSE &&
                    xaccAccountGetType(acct) != INCOME) 
            printf("  %4d: %s\n", i, xaccAccountGetName(acct));
        }
      }
      menu_needed = 0;
    }
    input = readline(prompt);    
    if(!input) {
      done = 1;
    } else {
      char *endptr = NULL;
      int acct_id = strtol(input, &endptr, 10);
      if((*input != '\0') && (*endptr == '\0')) {
        /* valid */
        result = xaccGetAccountFromID(ag, acct_id);
        if(result) done = 1;
        else printf("Invalid input.  Try again.\n");
      } else {
        printf("Invalid input.  Try again.\n");
      }
    }
    free(input);
    input = NULL;
  }
  return result;
}

static void
add_accounts_to_history(AccountGroup *ag) {
  /* Doesn't do what I thought it might */
  const int num_accts = xaccGetNumAccounts(ag);
  int i;
  for(i = 0; i < num_accts; i++) {
    Account *acct = xaccGetAccountFromID(ag, i);
    if(acct) add_history(xaccAccountGetName(acct));
  }
}

static int
query_user_bool(const char prompt[]) {
  int done = 0;
  int result = 0;
  while(!done) {
    char *input = NULL;
    char *rl_prompt;
    asprintf(&rl_prompt, "%s? [y/n] ", prompt);
    input = readline(rl_prompt);
    free(rl_prompt);
    rl_prompt = NULL;
    assert(input);
    if(*input) {
      char answer[2];
      if(sscanf(input, " %1[yn]", answer) != 1) {
        printf("Invalid response\n");
      } else {
        result = (*answer == 'y');
        done = 1;
      }
    } else {
      printf("Invalid response\n");
    }
    free(input);
    input = NULL;
  }
  return result;
}

static Account *
query_user_account(AccountGroup *ag, const char prompt[]) {
  Account *acct = NULL;
  HISTORY_STATE *hstate = history_get_history_state();
  char *input = NULL;
  int done = 0;

  //add_accounts_to_history(ag);
  
  while(!done) {
    input = readline(prompt);
    if(!input) break;
    
    acct = xaccGetAccountFromName(ag, input);
    if(acct) { 
      done = 1;
    } else {
      printf("Can't find account named %s\n\n", input);
    }    
    /* all the intermediate user entries won't be added to the
       history.  This is probably a bug. */
    if(!done) {
      free(input);
      input = NULL;
    }
  }
  history_set_history_state(hstate);
  if(input) {
    add_history(input);
    free(input);
    input = NULL;
  }
  return(acct);
}

void
split_print(Split *split, FILE *stream, const char prefix[]) {
  const char *split_memo = xaccSplitGetMemo(split);
  const double split_value = xaccSplitGetValue(split);
  Account *split_dest = xaccSplitGetAccount(split);
  const char *dest_name =
    split_dest ? xaccAccountGetName(split_dest) : NULL;
  
  fputc('\n', stream);
  fputs(prefix, stream);
  fprintf(stream, "  %10.2f | %15s | %s",
          split_value,
          dest_name ? dest_name : "<no-account-name>",
          split_memo ? split_memo : "<no-split-memo>");
}

void
transaction_print(Transaction *txn, FILE *stream, const char prefix[]) {
  time_t date = xaccTransGetDate(txn);
  const char *num = xaccTransGetNum(txn);
  const char *desc = xaccTransGetDescription(txn);
  const char *memo = xaccSplitGetMemo(xaccTransGetSplit(txn, 0));
  const double total = xaccSplitGetValue(xaccTransGetSplit(txn, 0));

  fputs(prefix, stream);
  if(date) {
    char *datestr = xaccTransGetDateStr(txn);
    fprintf(stream, "%s", datestr);
    free(datestr);
  } else {
    fprintf(stream, "<no-date>");
  }
  fputc(' ', stream); 
  if(num) {
    fputs(num, stream);
  } else {
    fprintf(stream, "<no-num>");
  }

  fputc('\n', stream);
  fputs(prefix, stream);
  if(desc) {
    fputs("  ", stream);
    fputs(desc, stream);
  } else {
    fprintf(stream, "<no-description>");
  }
  
  fputc('\n', stream);
  fputs(prefix, stream);
  if(memo) {
    fputs("  ", stream);
    fputs(memo, stream);
  } else {
    fprintf(stream, "<no-transaction-memo>");
  }
  
  {
    int split_count = xaccTransCountSplits(txn);
    int i;
    for(i = 1; i < split_count; i++) {
      Split *split = xaccTransGetSplit(txn, i);
      split_print(split, stream, prefix);
    }
  }
  fputc('\n', stream);

  fputs(prefix, stream);
  fprintf(stream, "  %10.2f -- Transaction total\n", total);
}

#if 0
  if (first_split) { 
     get_first_split();
     edit_first_split();  // or replace, if desired
  }
  if (second_split) { 
     get_second_split();
     edit_second_split();  // or replace, if desired
  }
  else {
     malloc_new_split();
     edit_split();
     insert split into trans();
  }
#endif


static void
transaction_add(AccountGroup *ag, Account *acct) {
  int done = 0;
  while(!done) {
    char *input = NULL;
    Transaction *txn = xaccMallocTransaction();
    assert(txn);
    xaccTransBeginEdit(txn);

    if(txn) { 
      int year; int month; int day;      
      input = readline("Enter date YYYY-MM-DD: ");
      if(!input) {
        done = 1;
        xaccTransDestroy(txn); txn = NULL;
      } else {
        if(*input) { add_history(input); }
        if(sscanf(input, " %d-%d-%d", &year, &month, &day) != 3) {
          printf("Bad date\n");
          free(input);
          input = NULL;
          xaccTransDestroy(txn);
          txn = NULL;
        } else {
          xaccTransSetDate(txn, day, month, year);
          free(input);
          input = NULL;
        }
      }
    }
    
    if(txn) {
      char *prompts[] = {
        "Enter num: ",
        "Enter description: ",
        "Enter transaction memo: "
      };
      void (*func[])(Transaction *, const char *) = {
        xaccTransSetNum,
        xaccTransSetDescription,
        xaccTransSetMemo
      };
      int item;
      for(item = 0; txn && item < sizeof(prompts)/sizeof(char *); item++) {
        if(txn) {
          input = readline(prompts[item]);
          if(!input) {
            done = 1;
            xaccTransDestroy(txn);
            txn = NULL;
          } else if(*input) {
            add_history(input);
            func[item](txn, input);
            free(input);
            input = NULL;
          } else {
            free(input);
            input = NULL;
          }
        }
      }
    }

    if(txn) {
      int finished_splits = 0;
      unsigned int split_line = 1; // 0 is source_split
      double total = 0;
      
      printf("\n");
      
      while(!finished_splits) {
        Split *split;
        double value;

        if(split_line > 1) {
          split = xaccMallocSplit();
          assert(split);
          xaccTransAppendSplit(txn, split);
        } else {
          split = xaccTransGetSplit(txn, 1);
        }
        

        if(split) {
          input = readline("Enter split memo: ");
          if(!input) {
            finished_splits = 1;
            done = 1;
            xaccTransDestroy(txn);
            txn = NULL;
            split = NULL;
          } else if(*input) {
            add_history(input);
            xaccSplitSetMemo(split, input);
            free(input);
            input = NULL;
          } else {
            free(input);
            input = NULL;
          }
        }
        
        if(split) {
          input = readline("Enter amount: ");
          if(!input) {
            finished_splits = 1;
            done = 1;
            xaccTransDestroy(txn);
            txn = NULL;
            split = NULL;
          } else {         
            if(*input) { add_history(input); }
            if(sscanf(input, " %lf", &value) != 1) {
              printf("Bad amount\n");
              free(input);
              input = NULL;
              if(split_line > 1) xaccSplitDestroy(split);
              split = NULL;
            } else {
              xaccSplitSetValue(split, -value);
              total += value;
              free(input);
              input = NULL;
            }
          }
        }
        
        if(split) {
          Account *dest_acct = 
            select_account(ag, "Enter the split destination: ", 1);
          
          if(!dest_acct) {
            finished_splits = 1;
            done = 1;
            xaccTransDestroy(txn);
            txn = NULL;
            split = NULL;
          }
        }
        split_line++;
        
        if(split) {
          if(!query_user_bool("Enter another split")) {
            finished_splits = 1;
          }
        }
      }
      
      if(txn) {
        Split *source_split = xaccTransGetSplit(txn, 0);
        xaccSplitSetValue(source_split, total);
        xaccAccountInsertSplit(acct, source_split);
      }

      transaction_print(txn, stdout, "");
      if(!query_user_bool("Transaction OK")) {
        xaccTransDestroy(txn);
        txn = NULL;
      } else {
        xaccTransCommitEdit(txn);
      }
    }
    if(!query_user_bool("Another transaction")) {
      done = 1;
    }
  }
}
  
static void
transaction_edit(Transaction *txn, AccountGroup *ag) {
  int done = 0;

  if(!txn) return;

  while(!done) {
    char *input = NULL;

#if 0
    if(txn) { 
      int year; int month; int day;      
      input = readline("Enter date YYYY-MM-DD: ");
      if(!input) {
        done = 1;
      } else {
        if(*input) { add_history(input); }
        if(sscanf(input, " %d-%d-%d", &year, &month, &day) != 3) {
          printf("Bad date\n");
          free(input);
          input = NULL;
        } else {
          xaccTransSetDate(txn, day, month, year);
          free(input);
          input = NULL;
        }
      }
    }
    
    if(txn) {
      char *prompts[] = {
        "Enter num: ",
        "Enter description: ",
        "Enter transaction memo: "
      };
      void (*func[])(Transaction *, const char *) = {
        xaccTransSetNum,
        xaccTransSetDescription,
        xaccTransSetMemo
      };
      int item;
      for(item = 0; txn && item < sizeof(prompts)/sizeof(char *); item++) {
        if(txn) {
          input = readline(prompts[item]);
          if(!input) {
            done = 1;
          } else if(*input) {
            add_history(input);
            func[item](txn, input);
            free(input);
            input = NULL;
          } else {
            free(input);
            input = NULL;
          }
        }
      }
    }
#endif
    
    if(txn) {
      int split_count = xaccTransCountSplits(txn);
      int i;
      
      if(!split_count) {
        fprintf(stdout, "Correcting missing destination split.\n"); 
        
        {
          Account *dest_acct = 
            select_account(ag, "Enter the split destination: ", 1);
          Split *source_split = xaccTransGetSplit(txn, 0);
          Split *split = xaccMallocSplit();
  
          if(dest_acct) {
            xaccSplitSetValue(split, xaccSplitGetValue(source_split));
            xaccTransAppendSplit(txn, split);
            xaccAccountInsertSplit(dest_acct, split);
          } else {
            done = 1;
            xaccTransDestroy(txn);
            txn = NULL;
            split = NULL;
          }
        }
      }
      for(i = 1; i < split_count; i++) {
        Split *split = xaccTransGetSplit(txn, i);
        const char *split_memo = xaccSplitGetMemo(split);
        const double split_value = xaccSplitGetValue(split);
        Account *split_dest = xaccSplitGetAccount(split);
        const char *dest_name = xaccAccountGetName(split_dest);
        
      }
    }      

    //if(txn) {
    //  Split *source_split = xaccTransGetSourceSplit(txn);
    //  xaccSplitSetValue(source_split, total);
    //  xaccAccountInsertSplit(acct, source_split);
    //}
    done = 1;
  }
}


static void
transaction_validate(Transaction *t, AccountGroup *ag) {
  
  int test;

  if(xaccTransCountSplits(t) == 0) {
    fprintf(stderr, "NO DEST splits!!!\n");
    transaction_print(t, stderr, "");
    transaction_edit(t, ag);
  }

#if 0
  if(strcmp(xaccTransGetDescription(t), "H.E.B.") == 0 &&
     xaccSplitGetAccount(xaccTransGetDestSplit(t, 0)) ==
     xaccGetAccountFromName(ag, "Computer")) {
    fprintf(stderr, "Buggered entry.\n");
    transaction_print(t, stderr, "");
    xaccMoveFarEnd(xaccTransGetDestSplit(t, 0),
                   xaccGetAccountFromName(ag, "Food:Grocceries"));
    transaction_edit(t, ag);
  }
#endif

#if 0
  if (split != &(trans->source_split)) {
    partner_split = &(trans->source_split);
  } else {
    /* perform that transfer *only* if there is one split */
    if (trans->dest_splits) {
      if (0x0 != trans->dest_splits[0]) {
        if (0x0 == trans->dest_splits[1]) {
          partner_split = trans->dest_splits[0];
        }
      }
    }
  }
  #endif
}

static void
transactions_list(AccountGroup *ag, Account *acct) {
  /* Broken.  Really works on all accts.  Ignores acct */

  int num_accts = xaccGroupGetNumAccounts(ag);
  int i;
  xaccRecomputeGroupBalance(ag);    
  for(i = 0; i < num_accts; i++) {
    acct = xaccGetAccountFromID(ag, i);
    if(acct) {
      Split **splits;
      splits = xaccAccountGetSplitList(acct);
      
      while(*splits) {
        Transaction *parent = xaccSplitGetParent(*splits);
        transaction_validate(parent, ag);
        while(*splits && xaccSplitGetParent(*splits) == parent) splits++;
      }
    }
  }
}

static void
work_on_acct(AccountGroup *ag, Account *acct) {
  char *menu_items[] = {
    "Add transaction.",
    //"Edit transaction.",
    "List transactions.",
    "Quit."
  };
  void (*menu_funcs[])(AccountGroup *, Account *) = {
    transaction_add,
    //transaction_edit,
    transactions_list,
    NULL
  };

  int menu_needed = 1;
  int done = 0;
  while(!done) {
    char *input = NULL;
    if(menu_needed) {
      int i;
      for(i = 0; i < sizeof(menu_items)/sizeof(char *); i++) {
        printf("  %4d: %s\n", i, menu_items[i]);
      }
      menu_needed = 0;
    }
    input = readline("Action? ");    
    if(!input) {
      done = 1;
    } else {
      char *endptr = NULL;
      int selection = strtol(input, &endptr, 10);
      if((*input != '\0') && (*endptr == '\0')) {
        if(selection < sizeof(menu_items)/sizeof(char *)) {
          if(menu_funcs[selection]) {
            menu_funcs[selection](ag, acct);
            menu_needed = 1;
          } else {
            /* User selected quit */
            done = 1;
          }
        } else {
          printf("Invalid input.  Try again.\n");
        }
      } else {
        printf("Invalid input.  Try again.\n");
      }
    }
    free(input);
  }
}

int
main(int argc, char *argv[]) {
  char *filename = NULL;
  AccountGroup *ag = NULL;
  Account *acct = NULL;
  
  assert(argc == 2);
  filename = argv[1];
  ag = xaccReadAccountGroup(filename);  
  assert(ag);

  do {
    acct = select_account(ag, "Edit which account (Ctrl-D exits)? ", 0);
    if(acct) {
      work_on_acct(ag, acct);
    }
  } while(acct);
  
  if(query_user_bool("\nSave changes")) {
    if(xaccWriteAccountGroup(filename, ag) < 0) {
      printf("Save error number %d\n", xaccGetFileIOError());
      exit(1);
    }
  }
  return 0;
}
