/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: Day.c,v 1.1.1.1 1996/04/16 15:12:03 leon Exp $ */

#include <memory.h>
#include <stdio.h>
/*#include <stdlib.h>*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#ifndef Mips
#include <malloc.h>
#endif /* !Mips */
#include "DayP.h"
#include "misc.h"

#define ClearWidget(w) \
XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 9999, 9999, True)



static void
SelectProc(Widget w, XEvent *event, String *args, Cardinal  *num_args);

#define max(a,b) (((a) > (b)) ? (a) : (b))

static char defaultTranslations[] = "<Btn1Down>: Select()\n";
static XtActionsRec actions[] = {
    {"Select", SelectProc},
};


static XtResource 
resources[] = {
#define offset(field) XtOffset(DayWidget, day.field)
  {XtNagenda, XtCAgenda, XtRPointer, sizeof(Agenda),
     offset(agenda), XtRImmediate, (caddr_t)NULL},
  {XtNdate, XtCDate, XtRDate, sizeof(Date),
     offset(date), XtRImmediate, (caddr_t)NULL},
  {XtNappointmentCallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
     offset(appointmentCallback), XtRPointer, NULL}, 
  {XtNnoteCallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
     offset(noteCallback), XtRPointer, NULL}, 
  {XtNhourColor, XtCHourColor, XtRPixel, sizeof(Pixel),
     offset(hourColor), XtRString, "black"},
  {XtNappointmentColor, XtCAppointmentColor, XtRPixel, sizeof(Pixel),
     offset(appointmentColor), XtRString, "red"},
  {XtNfirstHour, XtCFirstHour, XtRInt, sizeof(int),
     offset(firstHour), XtRImmediate, (caddr_t)8},
  {XtNlastHour, XtCLastHour, XtRInt, sizeof(int),
     offset(lastHour), XtRImmediate, (caddr_t)17},
  {XtNdevideHourIn, XtCDevideHourIn, XtRInt, sizeof(int),
     offset(devideHourIn), XtRImmediate, (caddr_t)4},
  {XtNmilTime, XtCMilTime, XtRBoolean, sizeof(Boolean),
     offset(milTime), XtRImmediate, (caddr_t)True},
  {XtNuserData, XtCUserData, XtRPointer, sizeof(XtPointer),
     offset(userData), XtRImmediate, (caddr_t)NULL},
  {XtNredraw, XtCRedraw, XtRBoolean, sizeof(Boolean),
     offset(redraw), XtRImmediate, (caddr_t)False},

/* fonts */
  {XtNhourFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(hourFont), XtRString, XtDefaultFont},
  {XtNappointmentFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(appointmentFont), XtRString, XtDefaultFont},
  

#undef offset
};



static void
SelectProc(Widget w, XEvent *event, String *args, Cardinal  *num_args)
{
    DayWidget yw = (DayWidget)w;
    XButtonEvent *e = (XButtonEvent *)event;
    static DayCallbackStruct cs;

    DayAppointment da;
#define THIS yw->day
    int asc, inc, i, h, x, y;

    asc = max(THIS.hourFont->ascent, THIS.appointmentFont->ascent);
    inc = max(THIS.hourFont->ascent + THIS.hourFont->descent, 
	      THIS.appointmentFont->ascent + THIS.appointmentFont->descent);
    x = e->x;
    y = e->y;
    for(i = THIS.firstHour; i <= THIS.lastHour; i++) {
	y -= max(THIS.devideHourIn, THIS.appNum[i])*inc;
	h = i;
	if(y <= 0) break;
    }
    if(y > 0) return; /* no hour found */
    if(h < THIS.firstHour) h = THIS.firstHour;
    if(h > THIS.lastHour) h = THIS.lastHour;

    THIS.date.hour = h;
    THIS.date.minute = 0;
    da = NULL;
	 
     if(x > 50) {
	 /* let's try tyo find the clicked note */
	 y += max(THIS.devideHourIn, THIS.appNum[h])*inc;
	 da = THIS.appointments[h];
	 for(i = 0; (i < THIS.appNum[h]) &&( da != NULL); i++) {
	     y -= inc;
	     if(y <= 0) break;
	     da = da->next;
	 }
     }

    if(NULL == da) {
    /* we did not click on a note */
	if(THIS.appointmentCallback != NULL) {
	    cs.event = event;
	    cs.date = THIS.date;
	    XtCallCallbacks(w, XtNappointmentCallback, &cs);
	}
    }
    else {
	/* we clicked on a note */
	if(THIS.noteCallback != NULL) {
	    cs.event = event;
	    cs.date = THIS.date;
	    cs.id = da->id;
	    cs.note = da->note;
	    cs.repeat = da->repeat;
	    cs.cal = da->cal;
	    cs.ag = THIS.agenda;
	    XtCallCallbacks(w, XtNnoteCallback, &cs);
	}
    }
#undef THIS
 }



static void 
InitializeProc(Widget w, Widget new, ArgList args, Cardinal *n)
{    
    DayWidget yw = (DayWidget) new;
#define THIS yw->day
    int inc, h;
    Window win = DefaultRootWindow(XtDisplay(yw));
    Display *dpy = XtDisplay(yw);

    inc = max(THIS.hourFont->ascent + THIS.hourFont->descent, 
	      THIS.appointmentFont->ascent + THIS.appointmentFont->descent);
     
    
    THIS.hour_gc = XCreateGC(dpy, win, 0, 0);
    XSetFont(dpy, THIS.hour_gc, THIS.hourFont->fid);
    XSetForeground(dpy, THIS.hour_gc, THIS.hourColor);

    THIS.ap_gc = XCreateGC(dpy, win, 0, 0);
    XSetFont(dpy, THIS.ap_gc, THIS.appointmentFont->fid);
    XSetForeground(dpy, THIS.ap_gc, THIS.appointmentColor);

    if(!new->core.width) new->core.width = 20;
    new->core.height = (THIS.lastHour - THIS.firstHour + 1) * inc 
	* THIS.devideHourIn;

    for(h = 0; h < 24; h++) {
	THIS.appointments[h] = NULL;
	THIS.appNum[h] = 0;
    }
#undef THIS
}




static void
ExposeProc(Widget w, XEvent *event, Region r)
{
    DayWidget yw = (DayWidget)w;
#define THIS yw->day
    Display *dpy = XtDisplay(w);
    Window win = XtWindow(w);
    XExposeEvent *e = (XExposeEvent *)event;
    int h, y = 0;
    char buf[256];
    int asc, inc, step = 0, steps = 0, height = 0;
    DayAppointment da;


    THIS.redraw = False;
    asc = max(THIS.hourFont->ascent, THIS.appointmentFont->ascent);
    inc = max(THIS.hourFont->ascent + THIS.hourFont->descent, 
	      THIS.appointmentFont->ascent + THIS.appointmentFont->descent);

    if(e) {
	XRectangle rect[1];

	XClipBox(r, &(rect[0]));
	XSetClipRectangles(dpy, THIS.hour_gc, 0,0, rect, 1, Unsorted);
	XSetClipRectangles(dpy, THIS.ap_gc, 0,0, rect, 1, Unsorted);
    }

    for(h = THIS.firstHour; h<= THIS.lastHour; h++) {
	THIS.date.hour = h;
	DayGetDateString(w, THIS.date, buf);
/*
	if(THIS.milTime) {
	    sprintf(buf, "%d:00", h);
	} else {
	    sprintf(buf, "%d:00 %s", (h>12 ? h-12 : h), ((h>12)?"pm":"am"));
	}*/
	XDrawLine(dpy, win, THIS.hour_gc, 0, y, 
		  w->core.width, y);
	XDrawString(dpy, win, THIS.hour_gc,
			0, y + asc, buf, strlen(buf));
	THIS.date.hour = h;
	step = 0;
	for(da = THIS.appointments[h]; da != NULL; da=da->next) {
	    sprintf(buf, "%s", da->note);
	    XDrawString(dpy, win, THIS.hour_gc,
			50, y + asc, buf, strlen(buf));
	    step ++;
	    y += inc;
	    
	}
	if(step < THIS.devideHourIn) {
	    y += inc * (THIS.devideHourIn - step);
	    steps += THIS.devideHourIn;
	}
	else {
	    steps += step;
	}
    }
    height = steps * inc;
    if(height != w->core.height) {
	XtMakeResizeRequest(w, w->core.width, height, NULL, NULL);
    }
    XSetClipMask(dpy, THIS.hour_gc, None);
    XSetClipMask(dpy, THIS.ap_gc, None);
#undef THIS
}

static Boolean
SetValuesProc(Widget currentw, Widget requestw, Widget neww, 
	      ArgList args, Cardinal *num_args)
{
    DayWidget current = (DayWidget)currentw;
    DayWidget new = (DayWidget)neww;
    Boolean redraw = False;
    DayPart *cp, *np;
#define CURRENT current->day
#define NEW new->day
    cp = &(current->day);
    np = &(new->day);
    if(memcmp(&(CURRENT.date), &(NEW.date), sizeof(Date)))
	DayScanAppointments(neww);
    /* any change should be reflected */
    if(memcmp(cp, np, sizeof(DayPart))) {
	redraw = True;
    }
    return redraw;
#undef CURRENT
#undef NEW
}


DayClassRec dayClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Day",
    /* widget_size		*/	sizeof(DayRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	InitializeProc,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	NULL,
    /* expose			*/	ExposeProc,
    /* set_values		*/	SetValuesProc,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* day fields */
    /* empty			*/	0
  }
};

WidgetClass dayWidgetClass = (WidgetClass)&dayClassRec;



void
DayAddAppointment(Widget w, int hour, char *note, CalendarId cal, 
		  AppointmentId id, Repeat repeat, Boolean redraw)
{
    DayWidget yw = (DayWidget)w;
#define THIS yw->day
    DayAppointment newa, lasta;
    
#ifdef Trace
    fprintf(stderr,"registering: %s (%d = %s) in %d\n", note, id, 
	    XrmQuarkToString(id), cal);
#endif /* Trace */
    newa = Create(DayAppointmentRec);
    newa->next = NULL;
    newa->note = Strdup(note);
    newa->cal = cal;
    newa->id = id;
    newa->repeat = repeat;

    if(NULL == THIS.appointments[hour]) {
	THIS.appointments[hour] = newa;
	THIS.appNum[hour] = 1;
    }
    else {
	lasta = THIS.appointments[hour];
	while(lasta->next)
	    lasta = lasta->next;
	lasta->next = newa;
	THIS.appNum[hour] += 1;
    }
    if(redraw){
	XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 9999, 9999, True);
    }
#undef THIS    
}


void
DayClearAllAppointments(Widget w)
{
    DayWidget yw = (DayWidget)w;
#define THIS yw->day
    int h;
    DayAppointment da, next;

    for(h = 0; h < 24; h++) {
	da = THIS.appointments[h];
	while(da) {
	    next = da->next;
	    free(da->note);

/*	    if(0 != da) {*/
		free(da); 
/*		da = 0;
	    }*/

	    da = next;
	}
	THIS.appointments[h] = NULL;
	THIS.appNum[h] = 0;
    }
#undef THIS
}




static void
RegisterAppointment(AppointmentId aid, CalendarId cid, void *closure)
{
    Widget w = (Widget)closure;
    DayWidget yw = (DayWidget)w;
#define THIS yw->day


    DayAddAppointment(w, THIS.date.hour, aid->note, cid, aid, aid->repeat, False);

#undef THIS
}



void
DayScanAppointments(Widget w)
{
    DayWidget yw = (DayWidget)w;
#define THIS yw->day
    int h;

    DayClearAllAppointments(w);
    for(h = THIS.firstHour; h <= THIS.lastHour; h++) {
		THIS.date.hour = h;
		AgendaEnumerateAppointments(THIS.agenda, 
					    THIS.date, 
					    RegisterAppointment, 
					    (void *)w);
    }
#undef THIS
}


void
DayGetDateString(Widget w, Date date, char *str)
{
    DayWidget yw = (DayWidget)w;
#define THIS yw->day

    int h = date.hour;
    if(THIS.milTime) {
	sprintf(str, "%d:%.2d", h, date.minute);
    } else {
	sprintf(str, "%d:%.2d %s", (h>12 ? h-12 : h), date.minute,
		((h>12)?"pm":"am"));
    }
#undef THIS
}


void
DaySetDate(Widget w, Date date)
{
    DayWidget yw = (DayWidget)w;
#define THIS yw->day
    THIS.date = date;
    THIS.date.minute = 0;
    DayScanAppointments(w);
    ClearWidget(w);
#undef THIS
}
