/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: options.c,v 1.1.1.1 1996/04/16 15:12:05 leon Exp $ */
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include "Year.h"
#include "Day.h"
#include "main.h"

int
LoadOptionFile(Display *dpy, char *name)
{
  char fileName[256];
  XrmDatabase xdb;
  xdb = XrmGetDatabase(dpy);
  sprintf(fileName, "%s/%s", getenv("HOME"), name);
  return XrmCombineFileDatabase(fileName, &xdb, True);
}





void
SaveOptionsCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
    char fileName[256];
    char buf[16];
    char *name = (char *)client_data;
    char *layout;
    WeekDay wd;
    XrmDatabase xdb=NULL;
    int n;

    sprintf(fileName, "%s/%s", getenv("HOME"), name);

    /* saving the Year Layout */
    XtVaGetValues(year, XtNlayout, &layout, NULL);
    XrmPutStringResource(&xdb, "*form.yearf*year.layout", layout);

    /* saving the Year Start Week On */
    XtVaGetValues(year, XtNstartWeekOn, &wd, NULL);
    XrmPutStringResource(&xdb, "*form.yearf*year.startWeekOn", weekDayNames[wd]);

    /* saving Day Range */
    XtVaGetValues(day, XtNfirstHour, &n, NULL);
    sprintf(buf, "%d", n);
    XrmPutStringResource(&xdb, "*form.dayf.sday*day.firstHour", buf);
    XtVaGetValues(day, XtNlastHour, &n, NULL);
    sprintf(buf, "%d", n);
    XrmPutStringResource(&xdb, "*form.dayf.sday*day.lastHour", buf);
    


    XrmPutFileDatabase(xdb, fileName);


}
