/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: GaugeP.h,v 1.2 94/11/14 18:50:26 leon Exp $ */
#ifndef __GAUGEP_H
#define __GAUGEP_H



#include <Xm/PrimitiveP.h>
#include "Gauge.h"


#ifdef _cplusplus
extern "C" {
#endif



typedef struct {
    int empty;
} XmGaugeClassPart;

typedef struct _XmGaugeClassRec {    
    CoreClassPart	        core_class;
    XmPrimitiveClassPart	primitive_class;
    XmGaugeClassPart	        gauge_class;
} XmGaugeClassRec;


typedef struct _XmGaugePart{
    int value;
    int minimum;
    int maximum;
    unsigned char orientation;
    unsigned char processingDirection;

    XtCallbackList dragCallback;
    XtCallbackList valueChangedCallback;
    
    /* private fields */
    Boolean dragging;		/* drag in progress ? */
    int oldx, oldy;
    GC gc;
} XmGaugePart;


typedef struct _XmGaugeRec {
    CorePart		core;
    XmPrimitivePart	primitive;
    XmGaugePart	        gauge;
} XmGaugeRec;

extern XmGaugeClassRec xmGaugeClassRec;



#ifdef _cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif




#endif /* __GAUGEP_H */
/* DON'T ADD ANYTHING AFTER THIS #endif */
