#include <co.h>

extern char *shmat();	/* Undeclared in sys/shm.h */




/*-----------------------------------------------------------------------*
 *                                                                       *
 *  Nom de la fonction  :  f_co_shm_attach                               *
 *                                                                       *
 *  Sequence d'appel    :  f_co_shm_attach();                            *
 *                                                                       *
 *  Description         :  Attachement memoire partagee                  *
 *                                                                       *
 *-----------------------------------------------------------------------*
 *                                                                       *
 *  Parametres d'entree  : Aucun                                         *
 *                                                                       *
 *  Parametres d'entree/sortie : Aucun                                   *
 *                                                                       *
 *  Parametres de retour : Aucun                                         *
 *                                                                       *
 *  Variables globales   : p_co_share_tables                             *
 *                                                                       *
 *  Fonctions locales    : -                                             *
 *                                                                       *
 *  Fonctions globales   : -                                             *
 *                                                                       *
 *-----------------------------------------------------------------------*/
int f_co_shm_attach()
{
key_t l_key;
int l_id;
static char a_path[]=K_CO_ZONE1_PATH;

/*
 * Attach zone 1 (statique)
 */
	l_key = ftok(a_path, K_CO_ZONE1_KEY);
	l_id = shmget(l_key, sizeof(struct DATACOM), 0);
	if (l_id < 0) {
		Dprintf(stderr, "f_co_shm_attach: shmget: errno=%d", errno);
		return(1);
	}
	p_co_share_tables = (struct DATACOM *)shmat(l_id, NULL, 0);
	if (p_co_share_tables == NULL)
		return (2);


	return (0);
}
