#include <ihm.h>
#include <kdir.h>

static void f_kdir_msg_from_kmusic();

void (*p_kmusic_message)();

static XtInputId        l_kar_kmusic_id;

void  f_kdir_switch_kmus_msg();


f_kdir_launch_kmusic()
{
 int pid_kmusic;

 int l_co_socket_srv_c12;

 if ( f_co_dcl_serveur(K_CO_SOCKADDR_C12, &l_co_socket_srv_c12) == False)
   {
    Dprintf (stderr, "\nImpossible de declarer le serveur c12 \n");
    kdir_exit (-1);
   }

 pid_kmusic = fork();

 if (pid_kmusic == 0) /* le fils */
   {
    execlp("kmusic", "kmusic", (char *)0);
    Dprintf (stderr, "\nKDIR : Unable to launch Kmusic\n");
    exit (0);
   }
 else
   {
    l_co_socket_c12 = f_co_get_connexion (l_co_socket_srv_c12);

    p_kmusic_message = f_kdir_switch_kmus_msg;    

    l_kar_kmusic_id = XtAppAddInput(p_kar_ctx, l_co_socket_c12,
		XtInputReadMask, f_kdir_msg_from_kmusic, NULL);
   }
  
} 

static void f_kdir_msg_from_kmusic()
{
 int l_taille_lue;

 l_taille_lue = read(l_co_socket_c12, &a_data, 4);

 if (l_taille_lue == 0)
   {
    Dprintf (stderr, "\nLe lecteur est mort \n");
    kdir_exit(0);
   }

 /* faut-il consommer */
 if  (p_kmusic_message) (*p_kmusic_message)();
}

void f_kdir_switch_kmus_msg()
{
   switch (a_data.code)
   {
    case C2_SHELL : ChgIconifyShell(top_level);
              break;

    default : Dprintf (stderr, "\nKDIR : Msg %d from kmusic Not yet managed\n", a_data.code);
              break;
   }
}


