#include <ihm.h>
#include <klyr.h>

static Widget banner1, banner2, banner3;

static Widget patch, track;

char * f_klyr_read_kplay_other (BYTE length);

f_klyr_clear_banner()
{
 char texte[100] ;
 XmString s_texte;

 Dprintf (stderr, "\nKLYR CLEAR BANNER");

 strcpy (texte, "                          ");
 s_texte = XmStringCreateSimple (texte);


 XtVaSetValues (banner1, XmNlabelString, s_texte, NULL);
 XtVaSetValues (banner2, XmNlabelString, s_texte, NULL);
 XtVaSetValues (banner3, XmNlabelString, s_texte, NULL);
 XtVaSetValues (track, XmNlabelString, s_texte, NULL);
 XtVaSetValues (patch, XmNlabelString, s_texte, NULL);

 XmStringFree (s_texte);
}


f_klyr_init_banners()
{
 char texte[100] ;
 XmString s_texte;

 strcpy (texte, "                          ");
 s_texte = XmStringCreateSimple (texte);

 banner1 =  XtVaCreateManagedWidget (NULL, xmLabelWidgetClass, form_banner,
        XmNtopAttachment, XmATTACH_FORM,
        XmNleftAttachment, XmATTACH_FORM,
        XmNlabelString, s_texte, NULL); 

 banner2 =  XtVaCreateManagedWidget (NULL, xmLabelWidgetClass, form_banner,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, banner1,
        XmNleftAttachment, XmATTACH_FORM,
        XmNlabelString, s_texte, NULL); 

 banner3 =  XtVaCreateManagedWidget (NULL, xmLabelWidgetClass, form_banner,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, banner2,
        XmNleftAttachment, XmATTACH_FORM,
        XmNlabelString, s_texte, NULL); 

 track =  XtVaCreateManagedWidget (NULL, xmLabelWidgetClass, form_banner,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, banner3,
        XmNleftAttachment, XmATTACH_FORM,
        XmNlabelString, s_texte, NULL);

 patch =  XtVaCreateManagedWidget (NULL, xmLabelWidgetClass, form_banner,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, track,
        XmNleftAttachment, XmATTACH_FORM,
        XmNlabelString, s_texte, NULL);

 XmStringFree (s_texte);
}



f_klyr_mnge_banner(len_ban1, len_comm1, len_comm2)
BYTE len_ban1, len_comm1, len_comm2;
{
 XmString s_banner1, s_banner2, s_banner3;
 BYTE read_len;
 char * texte;

 texte = f_klyr_read_kplay_other (len_ban1); 
    
 s_banner1 = XmStringCreateSimple (texte);

 XtVaSetValues (banner1, XmNlabelString, s_banner1, NULL);

 XmStringFree (s_banner1);
      

 texte = f_klyr_read_kplay_other (len_comm1); 
 s_banner2 = XmStringCreateSimple (texte);

 XtVaSetValues (banner2, XmNlabelString, s_banner2, NULL);

 XmStringFree (s_banner2);



 texte = f_klyr_read_kplay_other (len_comm2); 
 s_banner3 = XmStringCreateSimple (texte);

 XtVaSetValues (banner3, XmNlabelString, s_banner3, NULL);

 XmStringFree (s_banner3);

}


f_klyr_mnge_track(track_len)
BYTE track_len;
{
 XmString s_track;
 
 char * texte;

Dprintf (stderr, "\nf_klyr_mnge_track BEGIN");

 texte = f_klyr_read_kplay_other (track_len); 
    
 s_track = XmStringCreateSimple (texte);


 XtVaSetValues (track, XmNlabelString, s_track, NULL);

 XmStringFree (s_track);


}

f_klyr_mnge_patch(patchlen)
BYTE patchlen;
{
 XmString s_patch;
 char * texte;
 
 texte = f_klyr_read_kplay_other (patchlen); 
    
 s_patch = XmStringCreateSimple (texte);

 XtVaSetValues (patch, XmNlabelString, s_patch, NULL);

 XmStringFree (s_patch);

}

char * f_klyr_read_kplay_other (length)
BYTE length;
{
 static char * texte;
 int read_len;

 if (texte)
   free (texte);

 if (length == 0)
   length = 1;

 texte = (char *) malloc (length+1);
 read_len = read(l_co_socket_c5, texte, length);;
 if (read_len == 0)
   {
    Dprintf (stderr, "\nKPLAY est mort \n");
    exit(0);
   }

 if (read_len != length)
   Dprintf (stderr, "\nKLYR : tailles differente attendue : %d, lue :%d", length, read_len);

 texte[length] = '\0';

 return (texte);
}
