#include <ihm.h>

#include <klyr.h>

static void f_klyr_msg_from_kplay();

void (*p_kplay_message)();

static XtInputId        l_kar_klyr_id;

f_klyr_init_klyr_kplay()
{
 f_klyr_connect_kplay();

 l_kar_klyr_id = XtAppAddInput(p_kar_ctx, l_co_socket_c5, XtInputReadMask,
                            f_klyr_msg_from_kplay, NULL);

 p_kplay_message= f_klyr_switch_msg_kplay;
}

f_klyr_connect_kplay()
{
 f_co_cnx_c5();
}

static void f_klyr_msg_from_kplay()
{
 int l_taille_lue;

 l_taille_lue = read(l_co_socket_c5, &a_data, 4);


 if (l_taille_lue == 0)
   {
    Dprintf (stderr, "\nKPLAY est mort \n");
    exit(0);
   }

 /* faut-il consommer */
 if  (p_kplay_message) (*p_kplay_message)();
}


void f_klyr_switch_msg_kplay()
{

 switch (a_data.code)
   {
    case C5_NEW : f_klyr_new_song(); break;
  
    case C5_TRACKN : f_klyr_trakn (a_data.par1); break;

    case C5_PATCHN : f_klyr_patchn (a_data.par1); break;

    case C5_CRLF : f_klyr_crlf (); break;

    case C5_LENGTH : f_klyr_length (a_data.par1); break;

    case C5_BEGIN : f_klyr_begin (); break;

    case C5_BANNER : f_klyr_mnge_banner (a_data.par1, a_data.par2, a_data.par3); break;

    case C5_SILENT : f_klyr_silent (); break;

    case C5_ON : f_klyr_on (); break;

    case C5_TXT_ON : f_klyr_txt_on (); break;

    case C5_TXT_OFF : f_klyr_txt_off (); break;

    case C5_EXIT : f_klyr_exit (); break;

    case C5_FT : f_klyr_ft (); break;

    case C5_FF : f_klyr_ff (); break;

    case C5_NB : f_klyr_nb (); break;

    case C5_AF : f_klyr_af (); break;

    case C5_AB : f_klyr_ab (); break;

    case C5_PF : f_klyr_pf (); break;

    case C5_ST : f_klyr_st (); break;

    default : Dprintf (stderr, "\nKLYR : Msg %d from kplay Not yet managed\n", a_data.code);
              break;
   }
}
