#include <ihm.h>
#include <klyr.h>

static SONG * root, * Pcur;

static Widget * tab_widget;

SONG * pcur;

static int X, Y;

static Boolean b_step_line;

static Boolean b_song_still_loaded;
Boolean b_silent;

static int cpt;

f_klyr_new_song()
{
 SONG * pt, *pt1;

Dprintf (stderr, "\nKLYR : NEW_SONG");
 
 b_song_still_loaded = False;
 b_silent = False;
 Pcur = NULL;

 pt = root;
 if (pt)
   {
    XtUnmanageChildren (tab_widget, cpt);
    while (pt != NULL)
      {
       XtDestroyWidget(pt->xmLabel);
       pt1 = pt;
       pt=pt->next_block;
       free(pt1);
      }
   }

 if (tab_widget)
   {
    free (tab_widget);
    tab_widget = NULL;
   }

 root = NULL;
 X = 10;
 Y= 10;
 cpt = 0;

 f_klyr_clear_banner();


 XtUnmanageChild (form_lyric);

 b_step_line = False;
 pcur = NULL;
}

f_klyr_step_line()
{
 short height;

 height = 0;

 if (pcur)
   XtVaGetValues (pcur->xmLabel, XmNheight, &height, NULL);

 X=10;
 Y+=height+10;
 
 b_step_line = True;
}

f_klyr_rec_text(texte)
char * texte;
{
 static SONG * plast;
 XmString label;
 short width;

 label = XmStringCreateSimple(texte);

 pcur = (SONG *)malloc(sizeof (SONG));

 pcur->step_line = b_step_line;

 b_step_line = False;

 pcur->xmLabel = XtVaCreateWidget(NULL, xmLabelWidgetClass, 
	form_lyric,
	XmNx, X,
	XmNy, Y,
	XmNforeground, Col_white,
	XmNlabelString, label,
	XmNrecomputeSize, False,
	NULL);

 if (root == NULL)
    root = pcur;

 XmStringFree (label);

 ++cpt;
 pcur->next_block = NULL;
 if (plast)
   {
    plast->next_block=pcur;
    pcur->prev_block=plast;
   }
 else
   pcur->prev_block=NULL;

 plast=pcur;

 XtVaGetValues(plast->xmLabel, XmNwidth, &width, NULL);
 X+=width;
}

f_klyr_text_on()
{
 f_klyr_scroll_next(Pcur);


 if (Pcur && !b_silent)
   XtVaSetValues(Pcur->xmLabel, XmNforeground, Col_yellow, NULL);

}

f_klyr_text_off()
{
 if (Pcur)
   Pcur=Pcur->next_block;
}

f_klyr_scroll_next(p)
SONG * p;
{
 if (p && p->next_block)
   p = p->next_block;
 else
   return;

 XmScrollVisible(scroll_lyric, p->xmLabel,  0 , 0); /* pour voir deja le prochain */

 while (p && !(p->step_line))
   p = p->next_block;

 if (p)
   XmScrollVisible(scroll_lyric, p->xmLabel,  0 , 0);
}

f_klyr_begin_song()
{
 int i = 0;

 if (!b_song_still_loaded)
   {
    if (cpt)
      {
       tab_widget = (Widget *) malloc ( cpt * sizeof (Widget));
       Pcur = root; 
       while (Pcur)
         {
          tab_widget[i] = Pcur->xmLabel;
          XtVaSetValues (Pcur->xmLabel, XmNforeground, Col_white, NULL);
          Pcur=Pcur->next_block;
          i++;
         }

       XtManageChildren (tab_widget, cpt);
       b_song_still_loaded = True;
      }
    XtManageChild (form_lyric);
   }
 else
   { 
    Pcur = root;
    while (Pcur)
      {
       XtVaSetValues (Pcur->xmLabel, XmNforeground, Col_white, NULL);
       Pcur=Pcur->next_block;
      }
   }

 
 Pcur = root;
 if (Pcur)
   XmScrollVisible(scroll_lyric, Pcur->xmLabel,  0 , 0);

 f_co_send (K_CO_TYPE_C6, C6_START, 0, 0, 0);

}


