#include <ihm.h>
#include <kmus.h>
#include <solo.xpm>
#include <solou.xpm>
#include <mute.xpm>
#include <muteu.xpm>

CONTROL_PANEL  tab_control_panel [K_NB_MAX_INST];

static Boolean Solo [K_NB_MAX_INST];
static Boolean Mute [K_NB_MAX_INST];

static BYTE AtLeastOneSolo;


f_kmus_CreateMultipleControl (widget)
Widget widget;
{
 int i;
 char formname[20];
 Widget form;
 char name[3];
 int cpt = 1;
 XmString labS;
 int pourcent2, pourcent1, mul;
 Widget tmp_w;
 int MAX_FORMS;
 Pixmap mute_pix, solo_pix, mute_pix_u, solo_pix_u;
 short cpt_form;

 mute_pix = f_kar_CreatePixmap ("mute.xpm", mute_xpm);
 solo_pix = f_kar_CreatePixmap ("solo.xpm", solo_xpm);
 mute_pix_u = f_kar_CreatePixmap ("muteu.xpm", muteu_xpm);
 solo_pix_u = f_kar_CreatePixmap ("solou.xpm", solou_xpm);

 MAX_FORMS = K_NB_MAX_INST +2;
 cpt_form = 0;
 for (i=0; i<MAX_FORMS; i++)
   {
     sprintf (formname, "formControl_%d", i);

     pourcent2 = (i<(MAX_FORMS/2))?50:100;
     pourcent1 = (i<(MAX_FORMS/2))?0:50;
     mul = (i<MAX_FORMS/2)?i:i-MAX_FORMS/2;


     form= XtVaCreateManagedWidget(formname, xmFormWidgetClass, widget,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNleftPosition, ((mul*100*2)/MAX_FORMS ),
			XmNrightPosition, (((mul+1)*100*2) /MAX_FORMS),
			XmNtopAttachment, XmATTACH_POSITION,
			XmNbottomAttachment, XmATTACH_POSITION,
			XmNtopPosition, pourcent1,
			XmNbottomPosition, pourcent2,
			XmNbackground, Col_grey70,
			XmNborderWidth, 1, NULL);

      if (i == 0 || i == MAX_FORMS/2)
        {
         XtVaSetValues (form,XmNbackground, Col_MidnightBlue, XmNforeground, Col_yellow, NULL);
         f_kar_DrawLabelsControls (form);
         continue;
        }

      tab_control_panel[cpt_form].form = form;


      sprintf (name, "%d", cpt++);
      labS = XmStringCreateLocalized (name);
      tmp_w = XtVaCreateManagedWidget("LabNumCtrl", xmLabelWidgetClass, tab_control_panel[cpt_form].form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNlabelString, labS,
			XmNtopOffset, 3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 2,
			NULL);
      tab_control_panel[cpt_form].mute	 = XtVaCreateManagedWidget("Tog_mute", xmToggleButtonWidgetClass, tab_control_panel[cpt_form].form,
			XmNleftAttachment, XmATTACH_POSITION, 
			XmNleftPosition, 22,
			XmNlabelType, XmPIXMAP,
			XmNindicatorOn, False,
			XmNselectPixmap, mute_pix,
			XmNlabelPixmap, mute_pix_u,
			XmNshadowThickness, 1,
			XmNtopAttachment, XmATTACH_FORM, NULL);


      XtAddCallback (tab_control_panel[cpt_form].mute, XmNvalueChangedCallback, 
		f_kmus_chg_mute, cpt_form);

      tab_control_panel[cpt_form].solo = XtVaCreateManagedWidget("Tog_solo", xmToggleButtonWidgetClass, tab_control_panel[cpt_form].form,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, tab_control_panel[cpt_form].mute,
			XmNindicatorOn, False,
			XmNlabelType, XmPIXMAP,
			XmNselectPixmap, solo_pix,
			XmNlabelPixmap, solo_pix_u,
			XmNshadowThickness, 1,
			XmNtopAttachment, XmATTACH_FORM, NULL);

      XtAddCallback (tab_control_panel[cpt_form].solo, XmNvalueChangedCallback, 
		f_kmus_chg_solo, cpt_form);

      tmp_w = XtVaCreateManagedWidget("V", xmLabelWidgetClass, tab_control_panel[cpt_form].form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset, 3,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 2,
			NULL);

#ifdef MOTIF2
      tab_control_panel[cpt_form].equalizer = XtVaCreateManagedWidget("Sca_vol", xmScaleWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_FORM, 
			XmNrightOffset, 5,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, tmp_w,
			XmNtopOffset, 2,
			XmNminimum, 0,
			XmNmaximum, 0x7F,
			XmNvalue, 0x7F,
			XmNsensitive, True,
			XmNprocessingDirection, XmMAX_ON_TOP,
			XmNorientation, XmVERTICAL,
			XmNsliderSize, 15,
			NULL);
#else
	tab_control_panel[cpt_form].equalizer = XtVaCreateManagedWidget("Sca_vol", xmScrollBarWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_FORM, 
			XmNrightOffset, 5,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 5,
			XmNtopWidget, tmp_w,
			XmNtopOffset, 2,
			XmNwidth, 10,
			XmNminimum, 0,
			XmNmaximum, 0x7F+2,
			XmNvalue, 0x7F,
			XmNsliderSize, 2,
			XmNsensitive, True,
			XmNprocessingDirection, XmMAX_ON_TOP,
			XmNorientation, XmVERTICAL,
			XmNshowArrows, False,
                        NULL);

#endif

	XtAddCallback (tab_control_panel[cpt_form].equalizer, XmNvalueChangedCallback, 
		f_kmus_eq_change, cpt_form);



#ifdef MOTIF2
      tab_control_panel[cpt_form].panning = XtVaCreateManagedWidget("Sca_pan", xmScaleWidgetClass, tab_control_panel[cpt_form].form,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNrightAttachment, XmATTACH_WIDGET, 
			XmNrightWidget, tab_control_panel[cpt_form].equalizer , 
			XmNrightOffset, 5,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 18,
			XmNvalue, 0x40,
			XmNminimum, 0,
			XmNmaximum, 0x7F,
			XmNsliderSize, 15,
			XmNorientation, XmHORIZONTAL, NULL);
#else
	tab_control_panel[cpt_form].panning= XtVaCreateManagedWidget("Sca_pan", xmScrollBarWidgetClass, tab_control_panel[cpt_form].form,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNrightAttachment, XmATTACH_WIDGET,
			XmNrightWidget, tab_control_panel[cpt_form].equalizer,
			XmNrightOffset, 5,
			XmNrightOffset, 5,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 18,
			XmNshowArrows, False,
			XmNvalue, 0x40,
			XmNminimum, 0,
			XmNmaximum, 0x7F,
			XmNheight, 12,
			XmNorientation, XmHORIZONTAL, NULL);
#endif

	XtAddCallback (tab_control_panel[cpt_form].panning, XmNvalueChangedCallback, 
		f_kmus_panning_chg, cpt_form);


      tab_control_panel[cpt_form].pitch = XtVaCreateManagedWidget("Gau_pitch", xmGaugeWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_WIDGET, 
			XmNrightWidget, tab_control_panel[cpt_form].equalizer,
			XmNrightOffset, 5,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 34,
			XmNvalue, 0x2000,
			XmNminimum, 0,
			XmNmaximum, 0x4000,
                        XmNheight, 8,
                        XmNleftOffset, 2,
			XmNprocessingDirection, XmMAX_ON_RIGHT,
			XmNsensitive, False,
			XmNorientation, XmHORIZONTAL,
			NULL);

      tab_control_panel[cpt_form].vibrato = XtVaCreateManagedWidget("Gau_vibr", xmGaugeWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_WIDGET, 
			XmNrightWidget, tab_control_panel[cpt_form].equalizer,
			XmNrightOffset, 5,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 49,
			XmNvalue, 0,
			XmNminimum, 0,
			XmNmaximum, 127,
                        XmNheight, 8,
                        XmNleftOffset, 2,
			XmNprocessingDirection, XmMAX_ON_RIGHT,
			XmNorientation, XmHORIZONTAL,
			XmNsensitive, False,
			NULL);


      tab_control_panel[cpt_form].breath = XtVaCreateManagedWidget("Gau_trem", xmGaugeWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_WIDGET, 
			XmNrightWidget, tab_control_panel[cpt_form].equalizer,
			XmNrightOffset, 5,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNtopAttachment, XmATTACH_POSITION,
			XmNvalue, 0,
			XmNtopPosition, 63,
			XmNminimum, 0,
			XmNmaximum, 127,
                        XmNheight, 8,
			XmNorientation, XmHORIZONTAL,
                        XmNleftOffset, 2,
			XmNprocessingDirection, XmMAX_ON_RIGHT,
			XmNsensitive, False,
			NULL);

      tab_control_panel[cpt_form].volume = XtVaCreateManagedWidget("Gau_vol", xmGaugeWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_WIDGET, 
			XmNrightWidget, tab_control_panel[cpt_form].equalizer,
			XmNrightOffset, 5,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 76,
			XmNvalue, 0,
			XmNminimum, 0,
			XmNmaximum, 127,
			XmNorientation, XmHORIZONTAL,
                        XmNheight, 8,
                        XmNleftOffset, 2,
			XmNsensitive, False,
			XmNprocessingDirection, XmMAX_ON_RIGHT,
			NULL);


      tab_control_panel[cpt_form].velocity = XtVaCreateManagedWidget("Gau_velo", xmGaugeWidgetClass, tab_control_panel[cpt_form].form,
			XmNrightAttachment, XmATTACH_WIDGET, 
			XmNrightWidget, tab_control_panel[cpt_form].equalizer,
			XmNrightOffset, 5,
			XmNleftAttachment, XmATTACH_FORM, 
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 90,
			XmNvalue, 0,
			XmNminimum, 0,
			XmNmaximum, 127,
                        XmNheight, 8,
			XmNorientation, XmHORIZONTAL,
                        XmNleftOffset, 2,
			XmNsensitive, False,
			XmNprocessingDirection, XmMAX_ON_RIGHT,
			NULL);

     cpt_form ++;
    }



}

f_kar_DrawLabelsControls (form)
Widget form;
{
 char * tab_name [] = {"Mute/Solo", "L-Panning-R", "Pitch", "Modulation", "Breath", "Volume", "Expression"};
 int  tab_pos [] = {0, 15, 29, 44, 59, 73, 86};
 int i;

 for (i=0; i<7; i++)
   XtVaCreateManagedWidget(tab_name[i], xmLabelWidgetClass, form,
			XmNrightAttachment, XmATTACH_FORM, 
			XmNtopPosition, tab_pos[i],
			XmNbackground, Col_MidnightBlue,
			XmNforeground, Col_yellow,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNleftAttachment, XmATTACH_FORM, 
			NULL);

}
     

void f_kmus_chg_mute (widget, Tag, data)
Widget widget;
XtPointer  Tag;
XmAnyCallbackStruct *data;
{
 Boolean state;
 short   tag;

 tag = (short ) Tag;

 XtVaGetValues (widget, XmNset, &state, NULL);

 Mute[tag] = state;
 
 if (state || !AtLeastOneSolo)
   {
    p_co_share_tables->mute[tag] = state; 
    if (state)
      f_kmus_off_led_on_canal ((BYTE)tag);
   }
 else
   if (Solo[tag]) 
     p_co_share_tables->mute[tag] = False; 

}

void f_kmus_chg_solo (widget, Tag, data)
Widget widget;
XtPointer  Tag;
XmAnyCallbackStruct *data;
{
 Boolean state;
 int i;
 short  tag;
 
 tag = (short ) Tag;

 XtVaGetValues (widget, XmNset, &state, NULL);

 if (state)
   AtLeastOneSolo ++ ;
 else
   AtLeastOneSolo --;


 Solo[tag] = state;

 if (AtLeastOneSolo)
   for (i=0; i<K_NB_MAX_INST; i++)
     if (!Solo[i])
       {
        f_kmus_off_led_on_canal ((BYTE)i);
        p_co_share_tables->mute[i] = True; 
       }
     else
       p_co_share_tables->mute[i] = False;
 else
   for (i=0; i<K_NB_MAX_INST; i++)
     {
      if (Mute[i])
        f_kmus_off_led_on_canal ((BYTE)i);
      p_co_share_tables->mute[i] = Mute[i]; 
     }
 

}

