/*****************************************************************************

	copypaste.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)copypaste.c	1.9     97/06/23


	DESCRIPTION: Part of the Mdb Application.
		Launch a Dialog with a pretty formatted
		selection of mdb items in Addressing Label style.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)copypaste.c      1.9		97/06/23"

#include "mdb.h"

#define CPASTE	"*copyPasteFormat"

/*
 * Externals.
 */
extern items	Item[];

/*
 * Local Variables.
 */
static Widget	PopUp;
static Widget	FrmText;
static Widget	CpText;
static char	Fbuff[1024];
static Boolean	First = True;
static Boolean	InUse = False;

/*
 * The Main Action Area:
 *      LabelString:            Callback:       cbValue:        Sens:   Help:
 */
static ActionAreaItem action_items[] = {
	{ "applyButton",	(XtCP)copyp_cb,	APPL,		0,	HAP },
	{ "saveButton",		(XtCP)copyp_cb,	SAVE,		0,	QUICK },
	{ "cancelButton",	(XtCP)copyp_cb,	QUIT,		0,	HCA },
	{ "helpButton",		(XtCP)copyp_cb,	HELP,		0,	QUICK },
};


/*
 * Launch the Dialog.
 */
/*ARGSUSED*/
void copy_paste( Widget parent )
{
	Widget frame_w;
	Widget rowcol, rowcol1;
	char *ptr;
	int n;
	Arg args[10];

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	if ( ! *xread(GetKeyItem()) )
		return;

	if ( First == True ) {
		/*
		 * Get default presentation format.
		 */


		if ( (ptr = GetRes( CPASTE )) != NULL )
			(void)strcpy( Fbuff, ptr );
		else 
			(void)sprintf( Fbuff, "%d",  GetKeyItem()  );

		First = False;
	}

	/*
	 * Create and map the Dialog.
	 */
	PopUp = CreateDialog( parent, "copyPasteWin" );
	InUse = True;

	n = 0;
        if ( XDefaultDepth( XtDisplay(GetTopWidget()), 0 ) == MONOCH ) {
		XtSetArg(args[n], XmNmarginWidth,	5); n++;
		XtSetArg(args[n], XmNmarginHeight,	5); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNborderWidth,	0); n++;
        }
	frame_w = XmCreateFrame( PopUp, "frameWin", args, n );

	rowcol = CreateRowColumn( frame_w, "copyPasteMainWin", XmVERTICAL, 0 );
	XtVaSetValues( rowcol, XmNspacing, 3, NULL );

	n = 0;
	XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT ); n++;
	XtSetArg(args[n], XmNeditable,		False ); n++;
	XtSetArg(args[n], XmNtraversalOn,	False); n++;
	XtSetArg(args[n], XmNhighlightOnEnter,	False); n++;
	XtSetArg(args[n], XmNcursorPositionVisible, False ); n++;
	CpText = XmCreateText( rowcol, "copyPasteText", args, n );
	AddHelp( CpText, "copyPasteText", QUICK );
	XtManageChild(CpText);

	rowcol1 = CreateRowColumn( rowcol, "formatWin", XmHORIZONTAL, 0 );

	(void)CreateLabel( rowcol1, "formatLabel" );

	XtVaSetValues( FrmText = CreateText( rowcol1, "formatText", HFR ),
		XmNwidth, 130, NULL );

	XmTextSetString( FrmText, Fbuff );

	(void)CreateActionArea( rowcol, action_items, XtNumber(action_items),
		NULL, NULL, NULL, True );

	XtManageChild(rowcol);
	XtManageChild(rowcol1);
	XtManageChild(frame_w);

	/*
	 * Apply format.
	 */
	copyp_cb( (Widget)NULL, APPL, NULL );

	MapDialog( parent, PopUp, 0, 0 );
}


/*ARGSUSED*/
void copyp_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		copyp_cb( NULL, QUIT, NULL );
}


/*ARGSUSED*/
void copyp_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	char *dbuff;
	char dbuff1[1024];
	int item, i;
	int totf = 1;
	char *ptr, *ptr1;

	if ( InUse == False )
		return;

	if ( client_data == QUIT ) {
		InUse = False;
		DestroyDialog(PopUp);
		return;
	}

	if ( client_data == HELP ) {
		help( PopUp, HINDX, HCP );
		return;
	}

	if ( client_data == SAVE ) {
		if ( SetRes( CPASTE, Fbuff ) == NULL )
			(void)xpmsg( PopUp, "error: falid to save Format" );
		return;
	}


	if ( client_data != APPL )
		return;

	/*
	 * Apply Format change request.
	 */
	ptr = XmTextGetString( FrmText );
	(void)strcpy( Fbuff, ptr );
	XtFree(ptr);
	ptr = (char *)Fbuff;
	
	while( (ptr = strchr( ptr, ' ' )+1) != (char *)1 ) totf++;

	bzero( dbuff1, sizeof(dbuff1) );
	ptr = (char *)Fbuff;

	for( i = 0; i < totf; i++ ) {
		/*
		 * Group field together.
		 */
		do {
			item = strtol( ptr, &ptr1, 0 );
			if ( GetSKeyItem() && (item == GetSKeyItem()) )

				/*
				 * Here we assume that
				 * the sKey is a human,
				 */
				(void)strcat( dbuff1, "Attn: " );

			if ( Item[item].type == STEXTW )
				dbuff = "";
			else
				dbuff = xread( item );

			if ( item == GetKeyItem() )
				if ( ! *dbuff )
					return;

			(void)strcat(dbuff1, dbuff );
			(void)strcat(dbuff1, " " );
			ptr = &ptr1[1];

		} while ( *ptr1 == ',' );

		(void)strcat( dbuff1, "\n" );
	}

	XmTextSetString( CpText, dbuff1 );
}
