/*****************************************************************************

	gsearch.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)gsearch.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Launch the Global Search Dialog.

	SEE ALSO:	search.c gchange.c

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)gsearch.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern long	NextPos;
extern items	Item[];

/*
 * Defined search.c
 */
extern char	KeyPattern[];
extern char	sKeyPattern[];

/*
 * Defined in gchange.c
 */
extern Boolean	GchSens(Boolean stat);

/*
 * Local Variables.
 */
static Widget	PopUp;
static Widget	FieldLabel;
static Boolean	InUse = False;

/*
 * Forward declarations.
 */
static void
gsearch1_cb(Widget w, int client_data, XmCommandCallbackStruct *cbs );

/*
 * The Main Action Area:
 *      LabelString:            Callback:       cbValue:        Sens:   Help:
 */
static ActionAreaItem action_items[] = {
	{ "nextButton",		(XtCP)gsearch1_cb,	NEXT,	0,	HNE },
	{ "cancelButton",	(XtCP)gsearch1_cb,	QUIT,	0,	HCA },
	{ "helpButton",		(XtCP)gsearch1_cb,	HELP,	0,	QUICK },
};


/*ARGSUSED*/
static void
gsearch1_cb(Widget w, int client_data, XmCommandCallbackStruct *cbs )
{

	char *ptr;
	int field;
	static char dbuff[1024];
	XmString str;

	xpmsg_close();

	if ( client_data == QUIT ) {
		InUse = False;
		DestroyDialog(PopUp);
		return;
	}

	if ( client_data == HELP ) {
		help( PopUp, HINDX, HGS );
		return;
	}

	if ( client_data == GO ) {

		/*
		 * Find item by field pattern.
		 */
		XmStringGetLtoR( cbs->value, XmSTRING_DEFAULT_CHARSET, &ptr );

		NextPos = 0;

		(void)strcpy( dbuff, ptr );
		XtFree(ptr);

		if ( ! db_gsearch( NextPos, &NextPos, &field, dbuff ) ) {
			(void)xpmsg( PopUp, "info: Nothing  found" );
			dbuff[0] = '\0';

			XtVaSetValues( FieldLabel, XmNlabelString,
					(XmString)NULL, NULL );

			(void)GchSens(False);
			copyp_cb( (Widget)NULL, DEL, NULL );
			return;
		}

	}

	if ( client_data == NEXT ) {

		/*
		 * Find next.
		 */
		if ( ! dbuff[0] )
			return;

		if ( ! db_gsearch( NextPos, &NextPos, &field, dbuff ) ) {
			(void)xpmsg( PopUp, "info: End of search" );

			XtVaSetValues( FieldLabel, XmNlabelString,
					(XmString)NULL, NULL );

			(void)GchSens(False);
			copyp_cb( (Widget)NULL, DEL, NULL );
			return;
		}

	}

	/*
	 * Update label with field title.
	 */
	str = XmStringCreateSimple( Item[field].title );
	XtVaSetValues( FieldLabel, XmNlabelString, str, NULL );
	XmStringFree(str);

	/*
	 * Update for continued ordinary search.
	 */
	(void)strcpy( KeyPattern, xread( GetKeyItem() ) );
	if ( GetSKeyItem() )
		(void)strcpy( sKeyPattern, "*" );
	else
		sKeyPattern[0] = '\0';

	/*
	 * Update Global Change, and cut & paste.
	 */
	(void)GchSens(True);
	copyp_cb( (Widget)NULL, APPL, NULL );
}

/*ARGSUSED*/
void gsearch_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		gsearch1_cb( NULL, QUIT, NULL );
}


/*ARGSUSED*/
void gsearch( Widget parent )
{

	Widget paned_w, form_w, cmd_w, tmp_w;
	Arg args[10];
	int n;

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	/*
	 * Launch the Dialog.
	 */
	PopUp = CreateDialog( parent, "gsearchWin" );
	InUse = True;

	paned_w = XmCreatePanedWindow( PopUp, "panedWin", NULL, 0 );

	form_w = XmCreateForm( paned_w, "formWin", NULL, 0 );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;
	cmd_w = XmCreateCommand( form_w, "gscmdWin", args, n );
	AddHelp( cmd_w, "gscmdWin", QUICK );

	XtAddCallback( cmd_w, XmNcommandEnteredCallback,
		(XtCP)gsearch1_cb, (XtPointer)GO );


	XtVaSetValues( tmp_w = CreateSeparator( form_w, 0 ),
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			cmd_w,
		XmNleftOffset,			5,
		XmNrightOffset,			5,
		NULL );

	XtVaSetValues( FieldLabel = CreateLabel( form_w, "." ),
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			tmp_w,
		XmNleftOffset,			5,
		XmNrightOffset,			5,
		NULL );
	AddHelp( FieldLabel, "gscmdLabel", QUICK );

	XtVaSetValues( CreateActionArea( form_w, action_items,
			XtNumber(action_items), NULL, 0, NULL, True ),
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			FieldLabel,
		XmNbottomAttachment,		XmATTACH_FORM,
		XmNleftOffset,			5,
		XmNrightOffset,			5,
		NULL );

	XtManageChild(cmd_w);
	XtManageChild(form_w);
	XtManageChild(paned_w);

	MapDialog( parent, PopUp, 0, 140 );

}
