/*****************************************************************************

	import.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)import.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Launch a file selection box to import
			a database in TAB format. Perform necessary
			international (Currently Swedish) character
			translation.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)import.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern items	Item[];

/*
 * Local Variables.
 */
static Widget	PopUp;
static Widget	Fs_w[3];
static Widget	FrmText;
static Widget	PreForm;
static Boolean	InUse = False;



/*ARGSUSED*/
static void
import_cb( Widget w, int client_data, XmFileSelectionBoxCallbackStruct *cbs )
{

	XmTextVerifyCallbackStruct cvalid;
	XmTextBlockRec text;
	int i, cnt, tot, nitem;
	int unknown;
	int pnitem = 0;
	int upd = 0;
	int new = 0;
	int ukn = 0;
	int ignored = 0;
	int errs = 0;
	int fatal = 0;
	int intr = 0;
	int nshort = 0;
	int first = 1;
	long val = 0;
	long ret;
	struct stat sbuf;
	char *path, *file, *ptr, *fmt, *pform;
	char *dbuff;
	char dbuff1[1024];
	FILE *ifd;

	if ( client_data != OK )
		return;

	if ( ! XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &path) )
		return;

	if ( (file = strrchr(path, '/')) == NULL )
		file = path;
	else
		file++;

	if (  stat( path, &sbuf ) < 0 ) {
		(void)xpmsg( PopUp, "error: %s", file );
		XtFree(path);
		return;
	}

	if ( (sbuf.st_mode & S_IFMT) != S_IFREG ) {
		errno = 0;
		(void)xpmsg( PopUp, "error: %s: invalid file type", path );
		XtFree(path);
		return;
	}

	pform = XmTextGetString( PreForm );

	if ( *pform ) {
		(void)sprintf( dbuff1, "%s %s", pform, path );
		if ( system( dbuff1 ) ) {
			errno = 0;
			(void)xpmsg( PopUp, "error: program failed" );
			XtFree(path);
			XtFree(pform);
			return;
		}

	}
	XtFree(pform);

	dbuff = (char *)XtMalloc( GetMaxFieldLen() );
 
	if ( (ifd = fopen( path, "r" )) == NULL ) {
		(void)xpmsg( PopUp, "error: %s", file );
		XtFree(path);
		XtFree(dbuff);
		return;
	}

	/*
	 * Obtain the import option.
	 */
	for( i = 0; i < 3; i++ ) {
		XtVaGetValues( Fs_w[i], XmNset, &val, NULL );
		if ( val )
			break;
	}

	fmt = XmTextGetString( FrmText );

	switch ( i ) {
		case 0:	val = DB_TRUNCATE;	break;
		case 1:	val = 0;		break;
		case 2:	val = DB_APPEND;	break;
	}

	if ( val == DB_TRUNCATE ) {
		if ( db_access( DB_WRITE, val, &ret, DB_EXACT ) == -1 ) {
			(void)xpmsg( PopUp, "error: truncate folder failed" );
			(void)fclose(ifd);
			XtFree(path);
			XtFree(dbuff);
			return;
		}
		/*
		 * Truncate is a one time action.
		 */
		val = DB_APPEND;
	}


	if ( db_lock(True) ) {
		(void)xpmsg( PopUp, "error: lock folder failed" );
		(void)fclose(ifd);
		XtFree(path);
		XtFree(dbuff);
		return;
	}

	(void)xpmsg( PopUp, "work: Please Wait..." );
	Wait(1);

	db_silent(True);
	cvalid.text = &text;

	while( fgets( dbuff, GetMaxFieldLen(), ifd ) != NULL ) {

		if ( CheckForInterrupt( ! val ? 5 : 50 ) ) {
			intr++;
			break;
		}

		cnt = strlen( dbuff );
		unknown = nitem = 0;

		/*
		 * Nordic character translation.
		 */
		for( i = 0; i < cnt; i ++ ) {
			switch( (unsigned char)dbuff[i] ) {
				case '\n': dbuff[i] = '\0'; break;
				case '\t': dbuff[i] = '\0'; nitem++;   break;
				case  VT:  dbuff[i] = '\n'; break;
				case Maring:     dbuff[i] = aring;     break;
				case Madieresis: dbuff[i] = adieresis; break;
				case Modieresis: dbuff[i] = odieresis; break;
				case MAring:     dbuff[i] = Aring;     break;
				case MAdieresis: dbuff[i] = Adieresis; break;
				case MOdieresis: dbuff[i] = Odieresis; break;
				case Meax:	 dbuff[i] = eax;       break;
			}
		}

		/*
		 * Do some sanity checking.
		 */
		if ( first ) {
			pnitem = nitem;
			first = 0;
		} else if ( pnitem != nitem ) {
			errs = 1;
			break;
		}

		if ( nitem > GetMaxItems() ) {
			if ( ! ignored )
				ignored = nitem - GetMaxItems();
			else if ( ignored != nitem - GetMaxItems() ) {
				errs = 1;
				break;
			}
			nitem = GetMaxItems();
		} else if ( ! nitem ) {
			errs = 1;
			break;
		}

		if ( nitem < GetMaxItems() )
			nshort = GetMaxItems() - nitem;

		tot = 0;

		for ( i = 0; i < nitem; i++ ) {

			if ( Valid( i, fmt ) )
				continue;

			ptr = &dbuff[tot];
			if ( (cnt = strlen( ptr )) ) {

				if ( Item[i].type != STEXTW ) {
					/*
					 * Check for unwanted chars.
					 */
					cvalid.text->length = cnt;
					cvalid.text->ptr = ptr;
					verify_cb( NULL, 0, &cvalid );
				}

				xwrite( ptr, i );

			} else {

				if ( i == GetKeyItem() ) {
					unknown = 1;
					ukn++;
					break;
				} else
					xwrite( "", i );
			}

			tot += cnt +1;
		}

		if ( unknown )
			continue;

		if ( (i = db_access( DB_WRITE, val, &ret, DB_EXACT )) == -1 ) {
			fatal = errno;
			break;

		}

		if ( i ) upd++; else new++;
        }

	(void)xpmsg( PopUp, "work:" );

	db_silent(False);
	(void)db_lock(False);

	/*
	 * Report result.
	 */
	if ( errs + ukn + ignored + upd + new + fatal  ) {

		*dbuff1 = '\0';

		if ( errs ) {
			(void)sprintf( dbuff1,
		      "`%s' does not appear to\nbe in the appropriate format.",
			file );
		} 

		if ( ignored ) {
			(void)sprintf( dbuff, 
				"\n%d tail field(s) ignored for each item.",
				ignored );
			(void)strcat( dbuff1, dbuff );
		}

		if ( ukn ) {
			(void)sprintf(dbuff,"\n%d unknown items ignored.", ukn);
			if( ignored > 0 )
				(void)strcat( dbuff1, dbuff );
		}

		if ( upd+new ) {
			(void)sprintf( dbuff,
			  "\n%d items updated, and %d new imported.", upd, new);
			(void)strcat( dbuff1, dbuff );
		}

		if ( nshort ) {
			(void)sprintf( dbuff,
				 "\nFewer fields (-%d) than expected.", nshort);
			(void)strcat( dbuff1, dbuff );
		}

		if ( intr )
			(void)strcat( dbuff1, "\n- INTERRUPTED" );

		if ( fatal ) {
			errno = fatal;
			(void)xpmsg( NULL, "error: %s\n", dbuff1 );
		} else {
			errno = 0;
			(void)xpmsg( NULL, "info: %s", dbuff1 );
		}

	}

	XtFree(path);
	(void)fclose(ifd);
	XtFree(dbuff);
	XtFree(fmt);
	InUse = False;
	XtDestroyWidget(PopUp);
}


/*ARGSUSED*/
static void
import_cancel_cb(Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	InUse = False;
	XtDestroyWidget(PopUp);
}

/*ARGSUSED*/
void import_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		import_cancel_cb( NULL, QUIT, NULL );
}


/*
 * Launch a file selection box with a radio box and format field added to it.
 */
/*ARGSUSED*/
void import( Widget parent )
{

	Widget rowcol, rowcol1, rowcol2;
	int n;
	Arg args[10];

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}
	InUse = True;

	PopUp = XmCreateFileSelectionDialog( parent, "importWin", NULL, 0 );

	XtAddCallback( PopUp, XmNokCallback,
			(XtCP)import_cb, (XtPointer)OK );

	XtAddCallback( PopUp, XmNcancelCallback,
			(XtCP)import_cancel_cb, NULL );

	AddHelp( PopUp, "", HIM );

	AddHelp( XmFileSelectionBoxGetChild( PopUp,
		XmDIALOG_CANCEL_BUTTON ), "", HCA );

	AddHelp( XmFileSelectionBoxGetChild( PopUp,
		 XmDIALOG_OK_BUTTON ), "", HOK );

	AddHelp( XmFileSelectionBoxGetChild( PopUp,
		   XmDIALOG_HELP_BUTTON ), "helpButton", QUICK );
	/*
	 * Could not find the Filter Button ??.
	 */

	XtVaSetValues( rowcol =
		CreateRowColumn( PopUp, "importOptWin", XmVERTICAL, 0 ),
		XmNspacing, 10,
		NULL );
	XtManageChild( rowcol );

	n = 0;
	XtSetArg( args[n], XmNspacing,		8 ); n++;
	XtSetArg( args[n], XmNborderWidth,	1 ); n++;
	XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
	rowcol1 = XmCreateRadioBox( rowcol,	"importRWin", args, n );
	XtManageChild(rowcol1);

	Fs_w[0] = CreateToggleButton( rowcol1,
			"importTruncate", (XtCP)NULL, 0, QUICK );
	Fs_w[1] = CreateToggleButton( rowcol1,
			"importUpdate", (XtCP)NULL, 0, QUICK ) ;
	Fs_w[2] = CreateToggleButton( rowcol1,
			"importAppend", (XtCP)NULL, 0, QUICK );

	XtVaSetValues( Fs_w[0], XmNset, True, NULL );

	XtVaSetValues( Fs_w[0], XmNhighlightOnEnter, True, NULL );
	XtVaSetValues( Fs_w[1], XmNhighlightOnEnter, True, NULL );
	XtVaSetValues( Fs_w[2], XmNhighlightOnEnter, True, NULL );

	XtManageChild( rowcol2 =
		CreateRowColumn( rowcol, "importItemWin", XmVERTICAL, 0 ));

	(void)CreateLabel( rowcol2, "formatLabel" );
	FrmText = CreateText( rowcol2, "formatText", HFR );

	(void)CreateLabel( rowcol2, "preformLabel" );
	PreForm = CreateText( rowcol2, "preformText", HIM );

	XtManageChild( PopUp );

}
