/*****************************************************************************

	list.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)list.c	1.9	97/06/23

	DESCRIPTION: Part of the Mdb Application.
			Launch a List Dialog to access db items
			directly.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)list.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Local Variables.
 */
static Widget	PopUp;
static Widget	Filt_w;
static Widget	Parent;
static Boolean	InUse = False;
static int	Totalloc;
static char	Filter[200];
static XmString	*Lbuff;
/*
 * Forward declarations.
 */
void list( Widget w );
static void
list_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs );

static ActionAreaItem action_items[] = {
	{ "filterButton",	(XtCP)list_cb,	GO,	0,	QUICK },
	{ "cancelButton",	(XtCP)list_cb,	QUIT,	0,	HCA },
	{ "helpButton",		(XtCP)list_cb,	HELP,	0,	QUICK },
};



/*ARGSUSED*/
static void
list_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	int i;
	char *ptr;

	if ( client_data == QUIT ) {
		InUse = False;
		DestroyDialog(PopUp);

		for( i = 0; i < Totalloc; i++ )
			XmStringFree(Lbuff[i]);

		XtFree((char *)Lbuff);
		return;
	}

	if ( client_data == GO ) {
		/*
		 * Rescan with new filter.
		 */
		(void)strcpy( Filter, ptr = XmTextGetString(Filt_w) );
		XtFree(ptr);
		(void)fclose( db_itemlist( NULL,
					   *Filter ? Filter : NULL, 0, &i));
		if ( ! i ) {
			errno = 0;
			(void)xpmsg( PopUp, "info: no items found" );
			return;
		}

		list_cb( NULL, QUIT, NULL );
		list( Parent );
		return;
	}

	if ( client_data == HELP )
		help( PopUp, HINDX, HLI );

}

/*ARGSUSED*/
void list_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		list_cb( NULL, QUIT , NULL );
}


/*ARGSUSED*/
static void select_cb(Widget w, int client_data, XmListCallbackStruct *cb )
{

	char *ptr;

	XmStringGetLtoR(cb->item, XmSTRING_DEFAULT_CHARSET, &ptr);

	setitem(ptr);

	XtFree(ptr);

	search_cb((Widget)NULL, GO, NULL );
}


/*
 * Used by qsort.
 */
/*ARGSUSED*/
static int compar( char *s1, char *s2 )
{
        return(strcmp( s1, s2 ));
}


/*
 * Launch a (sorted) List Dialog.
 */
/*ARGSUSED*/
void list(Widget parent)
{

	Widget main_w, list_w;
	Widget rowcol_w, rowcol1_w;
	int n, i, tot, size, max;
	char *ptr, dbuff[1024];
	Arg args[20];
	FILE *fd;

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	Parent = parent;

	if ( ( fd = db_itemlist( NULL, *Filter ? Filter : NULL,
						0, &size)) == NULL ) {
		(void)xpmsg( parent, "error: open itemlist" );
		return;
	}

	if ( ! size ) {
		errno = 0;
		(void)xpmsg( parent, "info: no items found" );
		*Filter = '\0';
		(void)fclose(fd);
		return;
	}

	InUse = True;

	max = (GetMaxNameLen()+10) * 2;

	Lbuff = (XmString *)XtMalloc( sizeof(XmString) * size );
	ptr = (char *)XtMalloc( size * max );


	tot = 0;
	while( fgets( &ptr[ tot * max ], max-1 , fd ) != NULL ) {
		ptr[ (tot * max)+strlen(&ptr[tot * max])-1 ] = '\0';
		tot++;
	}

	(void)qsort( ptr, tot, max, (sortProc)compar );

	for( i = 0; i < tot; i++ ) {
		Lbuff[i] = XmStringCreateLtoR( &ptr[ i * max ],
				XmSTRING_DEFAULT_CHARSET );
	}

	Totalloc = tot;

	(void)fclose(fd);
	XtFree(ptr);

	PopUp = CreateDialog( parent, "listAllWin" );
	main_w = XmCreateForm( PopUp, "listForm", NULL, 0 );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNbottomOffset,	85 ); n++;
	XtSetArg(args[n], XmNtopOffset,		5 ); n++;
	XtSetArg(args[n], XmNleftOffset,	5 ); n++;
	XtSetArg(args[n], XmNrightOffset,	5 ); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNlistSizePolicy,	XmCONSTANT); n++;
	XtSetArg(args[n], XmNselectionPolicy,	XmSINGLE_SELECT); n++;
	XtSetArg(args[n], XmNvisibleItemCount,	tot > 20 ? 20 : tot+2); n++;
	list_w = XmCreateScrolledList( main_w, "listWin", args, n );
	AddHelp( list_w, "listWin", QUICK );
	
	XtAddCallback( list_w,
		XmNsingleSelectionCallback, (XtCP)select_cb, NULL );

	(void)sprintf( dbuff, "%d items found", tot );
	XtVaSetValues( XtParent(PopUp), XtNtitle, dbuff, NULL );

	rowcol_w = CreateRowColumn( main_w, "listRcWin", XmVERTICAL, 0 );
	XtVaSetValues( rowcol_w,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNrightAttachment,	XmATTACH_FORM,
		XmNrightOffset,		5,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNleftOffset,		5,
		XmNspacing,		3,
		NULL );
			
	(void)CreateSeparator( rowcol_w, 0 );

	rowcol1_w = CreateRowColumn ( rowcol_w, "filterWin", XmHORIZONTAL, 0 );
	(void)CreateLabel( rowcol1_w, "filterLabel" );
	Filt_w = CreateText( rowcol1_w, "nameFilter", QUICK );
	XmTextSetString( Filt_w, Filter );

	(void)CreateActionArea( rowcol_w, action_items,
		XtNumber(action_items), NULL, 0, NULL, True );

	XtManageChild(rowcol_w);
	XtManageChild(rowcol1_w);
	XtManageChild(list_w);
	XtManageChild(main_w);

	XtVaSetValues( list_w, XmNitems, Lbuff, XmNitemCount, tot, NULL );

	MapDialog( parent, PopUp, 0, 200 );

}
