/*****************************************************************************

	mdb.h

	Environment:    Unix R40V3/Solaris2/Linux.


	Revision history:	@(#)mdb.h	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)mdb.h      1.9		97/06/23"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#if defined(SVR4) || defined(linux)
#include <locale.h>
#endif
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>
#include <limits.h>
#include <ctype.h>
#include <time.h>
#include <signal.h>

/*
 * External functions.
 */
#if defined(__GNUC__)
int grantpt(int fildes);
int unlockpt(int fildes);
int fileno(FILE *stream);
#if ! defined(linux)
int putenv(char *string);
#endif
int kill(pid_t pid, int sig);
int ascftime(char *s, const char *format, const struct tm *timeptr);
char *ptsname(int fildes);
FILE *fdopen(int fildes, const char *type);
#endif

#if ! defined(DB)

#if defined(SYSV)
#undef SIGCHLD
#endif

#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/XmosP.h>
#include <Xm/Protocols.h>
#include <Xm/AtomMgr.h>
#include <Xm/MwmUtil.h>
#include <Xm/MainW.h>
#include <Xm/PanedW.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/SeparatoG.h>
#include <Xm/LabelG.h>
#include <Xm/Label.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ArrowBG.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/Scale.h>
#include <Xm/Command.h>

#include "patchlevel.h"

/*
 * Just to truncate
 * a long string.
 */
#define XtCP	XtCallbackProc


/*
 * A monochrome Monitor
 * with a depht of 1.
 */
#define MONOCH  1

/*
 * Remove all Dialogs
 */
#define ALL	1

/*
 * Called by qsort.
 */
#if !defined(lint) && !defined(__lint)
typedef int (*sortProc)(const void *, const void *);
#else
#define sortProc int
#endif

/*
 * An Action Area item.
 */
typedef struct {
	char	*label;
	void	(*callback)();
	int	data;
	int	sens;
	char	*help;
} ActionAreaItem;

/*
 * A Pop down menu item.
 */
typedef struct {
	char	*label;
	void	(*callback)();
	int	data;
	int	type;
	int	sens;
	int	sep;
	char	*help;
} MenuItem;

#define MAXRB	10
#define MAXRBL	40

/*
 * A Radio item.
 */
typedef struct {
	char   label[MAXRB*MAXRBL];
	Widget button[MAXRB];
} Radio;

/*
 * Callback commands.
 */
#define QUIT	0
#define ABORT	1
#define OPEN	2
#define DEF	3
#define GO	4
#define LIST	5
#define IMP	6
#define PRINT	7
#define CASE	8
#define CUTP	9
#define EXP	10
#define DEL	11
#define APPL	12
#define PREV	13
#define NEXT	14
#define HELP	15
#define SAVE	16
#define ADDI	17
#define DELI	18
#define TEST	19
#define RESET	21
#define OK	22
#define CLEAR	23
#define GHELP   24
#define MAIL	25
#define REPL	26
#define SEARCH	27

#define	PRT	50

/*
 * Help commands.
 */
#define HINDX	300
#define HPRD	301
#define HVERS	302
#define HONC	303

/*
 * Help Topics, short form.
 */
#define	HCP	"HCP"
#define HEX	"HEX"
#define HGC	"HGC"
#define HGS	"HGS"
#define HIM	"HIM"
#define HLI	"HLI"
#define HPR	"HPR"
#define HPO	"HPO"
#define HRM	"HRM"
#define HRE	"HRE"
#define HHE	"HHE"
#define HAP	"HAP"
#define HCA	"HCA"
#define HNE	"HNE"
#define HRE	"HRE"
#define HDI	"HDI"
#define HSE	"HSE"
#define HPE	"HPE"
#define HSV	"HSV"
#define HDE	"HDE"
#define HFR	"HFR"
#define HOK	"HOK"
#define HRA	"HRA"
#define HXT	"HXT"
#define HTG	"HTG"
#define HTC	"HTC"
#define HNL	"HNL"
#define HSR	"HSR"
#define HTL	"HTL"
#define HCI	"HCI"
#define HCG	"HCG"
#define HCM	"HCM"
#define HFO	"HFO"
#define HLA	"HLA"
#define HCC	"HCC"
#define HEM	"HEM"
#define HTE	"HTE"
#define HCQ	"HCQ"
#define HCT	"HCT"
#define HCS	"HCS"
#define HWP	"HWP"
#define HOR	"HOR"
#define HCN	"HCN"
#define HQM	"HQM"

#define QUICK	NULL

/********    Public Function Declarations    ********/

Widget CreateDialog(Widget parent, String name);
Widget CreateTempDialog(Widget parent, String name, XtCP close, XtPointer val );

void MapDialog(Widget top, Widget child, Dimension x, Dimension y);

void DestroyDialog(Widget top);

Widget CreateMenuBar(Widget parent);

Widget CreateSeparator(Widget parent, unsigned char val);

Widget CreateLabel(Widget parent, String name);

Widget CreateRowColumn(Widget parent,
		String name,
		unsigned char resource,
		int border);

Widget CreatePushButton(Widget parent,
		String name,
		void (*callback)(),
		int val,
		String help);

Widget CreateToggleButton(Widget parent,
		String name,
		void (*callback)(),
		int val,
		String help);

Widget CreateActionArea(Widget parent,
		ActionAreaItem *actions,
		int num_actions,
		Widget *activ,
		int *ind,
		Widget *butt,
		Boolean sep);

Widget CreatePulldownMenu(Widget parent,
		String name,
		MenuItem *items,
		int num_items,
		Widget *activ,
		int *ind);

Widget CreateHelpPulldownMenu(Widget parent,
		String name,
		MenuItem *items,
		int num_items,
		Widget *activ,
		int *ind);

Widget CreateText(Widget parent, String name, String help);

void AddHelp( Widget w, String name, String help );

/*VARARGS*/
Widget xpmsg(Widget w, ...);

void xpmsg_close(void);

void main_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void search_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void gsearch_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void gchange_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void save_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void reset_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void copyp_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void folder_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void edit_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void mail_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void verify_cb(Widget w, int cd, XmTextVerifyCallbackStruct *cbs);

void config_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

void help(Widget top, int hindx, char *topic);
void help_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);
void help_close(Widget w);
void dhelp_cb(Widget w, char *cd, XmAnyCallbackStruct *cbs);
void qhelp_cb(Widget w, String *help, XmAnyCallbackStruct *cbs);
XtActionProc
help_action(Widget w, XEvent *event, String *args, Cardinal *num_args);

void layout_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);

Boolean CheckForInterrupt(int cnt);

void setitem(char *ptr);

int Valid(int item, char *fmt);

typedef struct {
	pid_t pid;
	char file[100];
	char file1[100];
	Widget w;
	Boolean *pend;
	int retry;
} childStat;

XtInputCallbackProc
childDone( childStat *pst, int *fid, XtInputId *inputId );

#ifdef TTYMON
#define MAXCLINE	200
#define ERASE	'\010'

typedef struct {
	Widget w;
	Widget top;
	char slave_tty[80];
	char prompt[80];
	char program[160];
	int master;
	int slave;
	int emode;
	pid_t child;
	pid_t parent;
	FILE *fd;
	XtInputId in;
	short rows;
	short cols;
	XmTextPosition currInsert;
	Dimension x;
	Dimension y;
	Boolean alive;
	Boolean echo;
	Boolean lecho;
	Boolean recur;
	Boolean noResponse;
} CFILE;
	
CFILE *
attachChild( Widget top, char *cmd, char *prompt, Boolean echo, Widget w );

void detachChild( CFILE *  );
/*VARARGS*/
void fprintfChild( CFILE *cfd, ... );

void SpellInit( Widget sp_w, char *spellprg );
void SpellCheck( Widget w, Widget ed_w, int cmd,
		CFILE *cfd, Boolean *spon, XmTextPosition ofs );
#define SPELLCHECK	20000
#define SPELLON		20001
#define SPELLWORD	20002
#define SPELLWREP	20003
#define SPELLMAXW	40
#endif

void PrvSens(Boolean stat);
Boolean GchSens(Boolean stat);

Widget GetTopWidget(void);
XtAppContext GetAppContext(void);
Pixmap GetMdbPixmap(void);
char *GetTempFile(int typ);
size_t GetMaxNameLen(void);
size_t GetMaxFieldLen(void);
Dimension GetItemXLwidth(void);
int GetItemXTcolumns(void);
int GetMailItem(void);
unsigned char GetAppOrientation(void);
char *GetMailFormat(void);
char *GetRes(char *fmt, ...);
char *GetAppClass(void);
char *SetRes(char *res, char *val);
char *GetStartDir(void);
char *GetArgv(void);
char *GetPrinter(void);
char *TouchLayout(char *lname, Boolean *creat);
void RemoveTempFiles(void);
void PrintCommand( Widget w, int typ, char *printer,
		char *file, char *mpopt, char *mpp, int ack, Boolean *pend );
void TextSearch( Widget parent, Widget textw, Boolean *inuse );
void LineBreak( size_t limit, char *line );
void Wait(int sec);
#endif
int GetMaxItems(void);
int GetKeyItem(void);
int GetSKeyItem(void);
char *GetFolderClass(void);
char *GetFolderPath(void);
char *GetPrivateFolderPath(void);
char *GetFolder(int folder);
char *GetLayout(int layout);

#ifdef DB
typedef char		Boolean;
#define True		1
#define False		0
#define Widget		int
#endif

/*
 * An mdb Item.
 */
typedef struct {
	char	*title;
	Widget	w;
	int	type;
	char	*data;
	size_t	len;
} items;

/*
 * db_access() Options. Should be kept negative.
 */
#define	DB_APPEND	-1
#define DB_TRUNCATE	-2
#define DB_DELETE	-3

/*
 * db_access() Commands.
 */
#define DB_READ		False
#define DB_WRITE	True
#define DB_EXACT	True
#define DB_CASE		False

/*
 * Deleted Items.
 */
#define DELETED -1

char *xread(int item);

void xwrite(char *buff, int item);

int db_init(char *folder, char *folderpath);

FILE *db_itemlist(char *Pitems[], char *filter, int how, int *tot);

int db_access(Boolean save, long nextpos, long *curpos, Boolean exact);

Boolean db_gsearch(long nextpos, long *curpos, int *field, char *pattern);

char *db_notefile(void);

char *db_foldername(void);

char *db_folderrev(void);

char *db_class(void);

int db_folderitems(void);

Boolean db_iswritable(void);

void db_silent(Boolean stat);

int db_lock(Boolean stat);

/********    End Public Function Declarations    ********/

#if ! defined(PATH_MAX)
#define PATH_MAX 255
#endif

#define MDBEXT		".mdb"
#define CHANGED		10000

#if defined(DB) || defined(CONFIG)
/*
 * db header contents.
 */
#define DBTOT		"#Mdb items"
#define DBCLASS		"#Mdb class(%s)"
#define DBREV		"#Mdb revision(%s, Rev. %s)"
#define DBHEAD		"#Mdb title"
#define DBNOTES		"#Mdb remarks"
#define DBTAIL		"#Mdb fini"
#endif

#define DEFAULTPRINTER	"*defaultPrinter"
#define MPPRINT		1
#define LABELPRINT	2

#if defined(linux)
#define	MPPRINTCMD	"%s %s -bsdprint -printer %s %s"	
#define LBPRINTCMD	"groff -P-g -Tps %s | lpr -P %s"
#else
#define	MPPRINTCMD	"%s %s -printer %s %s"	
#if defined(GROFF)
#define LBPRINTCMD	"groff -P-g -Tps %s | lp -c -d %s"
#else
#define LBPRINTCMD	"troff -Tps88594 %s | /usr/lib/lp/postscript/dpost -Tps88594 -x -1 | lp -c -d %s"	
#endif
#endif

#define MPPAPER	"*mpPaper"
#define MPA4	"-a4"
#define MPUS	"-us"

#if defined(PR) || defined(MAIN)
/*
 * Addressing Label Print options.
 */
struct print_options {
	char	lformat[80];
	char	phformat[80];
	int	hsp1valA;
	int	hsp2valA;
	int	hsp3valA;
	int	vsp1valA;
	int	vsp2valA;
	int	fzA;
	char	nrowA[80];
	char	climitA[80];
	int	hsp1valB;
	int	hsp2valB;
	int	hsp3valB;
	int	vsp1valB;
	int	vsp2valB;
	int	fzB;
	char	nrowB[80];
	char	climitB[80];
	int	hsp1val;
	int	hsp2val;
	int	hsp3val;
	int	vsp1val;
	int	vsp2val;
	int	fz;
	char	nrow[80];
	char	climit[80];
};

#ifdef PR
/*
 * Print Layout.
 */
static char *Ptype[] = {
	"fullInformation",
	"addressLabels",
	"phoneBook",
	NULL
};

/*
 * These definitions
 * are bound to the
 * freeware 'mp' program.
 * Add as needed.
 */
static char *Popt[] = {
	"portrait",	"mp",
	"landScape",	"mp -landscape",
	"filofaxPo",	"filofaxp",
	"franklinPo",	"franklinp",
	"proplanPo",	"proplanp",
	"timemanPo",	"timemanp",
	"timesysiPo",	"timesysip",
	"timesyspPo",	"timesyspp",
	NULL, NULL
};

#endif

/*
 * troff header in metric style
 * for Label Print.
 */
#define LPRINTHEADERA4	".ll 20.90c\n.pl 29.70c\n.vs 0.50c\n.po 0\n.ft 2\n.ta %.2fc %.2fc %.2fc\n.sp %.2fc\n.ps %d\n"
#define LPRINTHEADERUS	".ll 21.59c\n.pl 27.94c\n.vs 0.50c\n.po 0\n.ft 2\n.ta %.2fc %.2fc %.2fc\n.sp %.2fc\n.ps %d\n"
#define LPVSPACE	".sp %.2fc\n"
#define LPVBREAK	".bp\n.sp %.2fc\n"
#endif

#if defined(EXPORT) || defined(MAIN)
/*
 * Netscape HTML Address book foramt string.
 */
#define HREC "<!DOCTYPE NETSCAPE-Addressbook-file-1>\n\
<!-- This is an automatically generated file.\n\
It will be read and overwritten.\n\
Do Not Edit! -->\n\
<TITLE>%s's Address book (%s)</TITLE>\n\
<H1>%s's Address book (%s)</H1>\n\n<DL><p>\n"

#define NREC " <DT><A HREF=\"mailto:%s\" NICKNAME=\"%s\">%s</A>\n<DD>%s\n"

#define EREC "</DL><p>"

#endif

/*
 * Default class/layout.
 */
#define LAYOUT		"Mdb"

/*
 * Supported item classes.
 */
#define RADIO		"Radio"
#define TOGGLE		"Toggle"
#define TEXTN		"Text"
#define STEXT		"Stext"
#define EMAIL		"Email"
#define MAXFOLDS	100
#define TEXTW		0
#define RADIOW		3
#define TOGLW		1
#define STEXTW		2
#define NULLW		-1

/*
 * Toggle State.
 */
#define ACTIVE		'X'
#define NACTIVE		'Z'

/*
 * The overall limit of items.
 */
#define MAXITEMS	100

/*
 * Private folder name.
 */
#define PRIVATE		"private"

/*
 * troff Swedish character set translations.
 */
#ifndef GROFF		/* groff supports 8 bit */
#define Raring		"\\(E5"
#define Radieresis	"\\(E4"
#define Rodieresis	"\\(F6"

#define RAring		"\\(C5"
#define RAdieresis	"\\(C4"
#define ROdieresis	"\\(D6"
#endif

/*
 * unix2mac Swedish character set translations.
 */
#define aring		(unsigned char)0xe5
#define adieresis	(unsigned char)0xe4
#define odieresis	(unsigned char)0xf6

#define Aring		(unsigned char)0xc5
#define Adieresis	(unsigned char)0xc4
#define Odieresis	(unsigned char)0xd6

#define Maring		(unsigned char)0x8c
#define Madieresis	(unsigned char)0x8a
#define Modieresis	(unsigned char)0x9a

#define MAring		(unsigned char)0x81
#define MAdieresis	(unsigned char)0x80
#define MOdieresis	(unsigned char)0x85

#define eax		(unsigned char)0xe9
#define Eax		(unsigned char)0xc9

#define  Meax		(unsigned char)0x8e
/* not yet
#dfine  MEax		(unsigned char)0x
*/
#define VT		(char)0x0b


#if ! defined(linux)
#define bzero(str, len) (void)memset(str, 0, len)
#endif

/*
 * Fall back resources.
 */
#ifdef MAIN
static char *errmsg = {"\
\n %s:\n\
 The  problems  listed  here were detected\n\
 during  initialization.  Please check the\n\
 existent, or the contents of the resource\n\
 file \"%s\" accordingly.\n\n" };

static String fall_back_res[] = {
	"*buttonFontList: 7x13",
	"*XmText.FontList: 7x13",
	"*borderWidth: 0",
	"*borderColor: black",
	"*background: white",
	"*foreground: black",
	"*frameWin.marginWidth: 10",
	"*frameWin.marginHeight: 10",
	"*frameWin.shadowThickness: 5",
	"*frameWin.shadowType: SHADOW_OUT",
	"*frameWin.borderWidth: 1",
	"*infoLabel.labelString: Good Night",
	"*errorDialog.dialogTitle: FATAL",
	NULL
};
#endif

#define FUNDEF	"NOT_YET_DEFINED"

#ifdef CONFIG
#define UP	200
#define DN	201

#define START	202
#define RESTART	203


#define MDBGEN	"MdbGen"

struct item {
	char des[80];
	char cls[40];
	char par[8];
	char hlp[80];
	char fnt[80];
	char bgr[80];
	char row[80];
	char col[80];
	char ori[80];
	char opt[80];
	char htm[80];
	Boolean key;
	Boolean skey;
	int pos;
};

struct fold {
	char name[40];
	char type;
};

#define LABEL		".labelString:"
#define BACKG		".background:"
#define PAREN		".parent:"
#define CLASS		".class:"
#define IHELP		".help:"

#define PKEYI		"*pKeyItem:"
#define SKEYI		"*sKeyItem:"
#define SEL2L		"*typeLabel"
#define SEL3L		"*sel1Label"
#define SEL4L		"*sel2Label"
#define FOLD		"*folder"


#define FONTL		".FontList:"
#define ROWS		".rows:"
#define COLS		".columns:"
#define ORI		".orientation:"
#define ROPT		".options:"
#define HTM		".htmlFormat:"

#define PRIM		"Text-primary"
#define SPRIM		"Text-sprimary"
#define TEXTL		"Text-cols="
#define TEXTS		"Stext-rows="
#define EMALL		"Email-html="

#define ITEMS		"Item Type"
#define RADIOB		".Radio"
#define VRADIO		"Radio-vert="
#define HRADIO		"Radio-horz="
#define TOGGLE		"Toggle"
#define NULLI		"NULL"

#define TTL2		"Title2"
#define TTL3		"Title3"
#define TTL4		"Title4"
#define TFOLD		"Folders"

#define FCLASSLY	"Folder LAYOUT"

#define FOLDERCLASS	"*folderClass:\t\t\t%s\n"
#define FOLDERINFO	"*folderInfo.labelString:\t%s\n"
#define GFOLDERPATH	"*folderGlobal:\t\t\t%s\n"
#define PFOLDERPATH	"*folderPrivate:\t\t\t%s\n"
#define FOLDERNX	"*folderName%d:\t\t\t%s\n"
#define FOLDERLX	"*folderLayout%d:\t\t\t%s\n"

#define EV_PRIM		1000
#define EV_SPRIM	1001
#define EV_TEXTL	1002
#define EV_TEXTN	1003
#define EV_TEXTS	1004
#define EV_VRADIO	1005
#define EV_HRADIO	1006
#define EV_TOGGLE	1007
#define EV_ITEM		1008
#define EV_NULLI	1009
#define EV_EMAIL	1010

#define EV_ITEMS	EV_PRIM

#define EV_TTL2		2000
#define EV_TTL3		2001
#define EV_TTL4		2002

#define EV_TITLES	EV_TTL2

#define EV_FOLD		3000

#define EV_FOLDERS	EV_FOLD

#define HORI		"XmHORIZONTAL"
#define VERT		"XmVERTICAL"

#define ENDRECORD \
"! End of config generated items. Do not alter this line.\n"
#endif
