/*****************************************************************************

	search.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)search.c	1.9	97/06/23

	DESCRIPTION: Part of the Mdb Application.
			Search for a db item.

	SEE ALSO:	gsearch.c and gchange.c

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)search.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern long	NextPos;

/*
 * Also referenced from gsearch.c
 */
char	KeyPattern[1024];
char	sKeyPattern[1024];

/*
 * Local Variables.
 */
static int	Hist[100];
static int	Hindex = 0;


/*ARGSUSED*/
void search(Widget w, Boolean prev)
{

	char dbuff[1024];
	char dbuff1[1024];
	int pos, i;

	if ( NextPos == 0 ) {
		Hindex = 0;
		(void)strcpy( KeyPattern, xread( GetKeyItem() ) );
		if ( GetSKeyItem() )
			(void)strcpy( sKeyPattern, xread( GetSKeyItem() ) );
		else
			sKeyPattern[0] = '\0';
	} else {
		xwrite( KeyPattern, GetKeyItem() );
		if ( GetSKeyItem() )
			xwrite( sKeyPattern, GetSKeyItem() );
	}

	if ( Hindex +1 >= sizeof(Hist)/sizeof(int) )
		Hindex = 0;

	if ( prev == True ) {
		if ( Hindex -1 > 0 )
			NextPos = Hist[--Hindex];
		else
			NextPos = 0;
	}


	if ( ! (pos = db_access( DB_READ, NextPos, &NextPos, DB_CASE )) ) {
		
		for( i = 0; i < GetMaxItems(); i++ ) {
			if ( i == GetKeyItem() ) continue;
			if ( GetSKeyItem() ) if ( i == GetSKeyItem() ) continue;
			xwrite( "", i );
		}

		if ( GetSKeyItem() && sKeyPattern[0] )
			(void)sprintf( dbuff1, " [%s]", sKeyPattern );
		else
			dbuff1[0] = '\0';

		(void)sprintf( dbuff, "%s%s:\nNot found or end of search.",
				KeyPattern, dbuff1 );

		(void)xpmsg( w, "info: %s", dbuff );
		NextPos = 0;
		(void)GchSens(False);
		copyp_cb( (Widget)NULL, DEL, NULL );
		return;

	} else if ( pos == -1 ) {
		(void)xpmsg( w, "error: db access" );
		for( i = 0; i < GetMaxItems(); i++ )
			xwrite( "", i );
		NextPos = 0;
		(void)GchSens(False);
		copyp_cb( (Widget)NULL, DEL, NULL );
		return;
	}

	if ( prev == False )
		Hist[++Hindex] = pos;


	/*
	 * Set sensitivity for
	 * Global Change and Previous.
	 */
	if ( GchSens(True) == True )
		PrvSens(False);
	else
		PrvSens( Hindex >1 ? True : False );

	copyp_cb( (Widget)NULL, APPL, NULL );

}
