# @(#)$Mu: make/sys.linux.mk,v 1.30 $
##
## sys.linux.mk
##	System dependent makefile for linux.
##	This should work with newer (gcc 2.7.2, libc 5) Linux installations.
##	Note that motif 2.0.0 has fatal bugs, get motif 2.0.1.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

sysname    = Linux (ELF)
sys        = SY_LINUX
mk-cde     = no
mk-putenv  = no
mk-xpm     = yes
mk-xnt     = no
mk-libhelp = no

cc      = gcc
perl    = /usr/local/bin/perl
warn    = -ansi -pedantic -Wall -Werror -Wmissing-prototypes
defs    = -D$(sys) -D_POSIX_SOURCE
opt     = -O
incl    = -I. -I/usr/local/include -I/usr/X11/include
ldflags = -s -L/usr/local/lib -L/usr/X11/lib $(opt)
##
## something like this:
## libs    = -lXpm -lXmu /usr/X11/lib/libXm.a -lXt -lX11 -lm
## will statically link the Motif library in but leave the rest of the
## libraries shared
##
xlibs   = -lXm -lXpm -lXmu -lXt -lX11 -lm
hlibs   = -lhlpclient
ar      = ar
arflags = r
m4      = m4 -P

dep    = gcc
dflags = -M

mkdir    = mkdirhier
install  = install -c
bindir   = /usr/local/bin
binflags = -o root -g root -m 755
mandir   = /usr/local/man/man1
manflags = -o root -g root -m 644
docdir   = /usr/local/lib/$(projname)
docflags = $(manflags)
addir    = $(docdir)
adflags  = $(docflags)
