/*
 * icons.c
 *	Icon handling for wlib.  This file exists to cleanly isolate
 *	the code that depends on the Xpm library.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: wlib/icons.c,v 1.3 $")

#if !defined(HAS_XPM)
#	error "You forgot to define HAS_XPM"
#endif

#include	<assert.h>
#include	<limits.h>
#include	<X11/Intrinsic.h>
#include	<Xm/XmStrDefs.h>
#include	<X11/Shell.h>
#if HAS_XPM
#	include	<X11/xpm.h>
#endif
#include	<wlib/wlib.h>
#include	<wlib/icons.h>
#include	<wlib/sanity.h>

static WL_ICONS icons = {
	NULL,
	NULL, 0, 0,
	NULL, 0, 0,
};

static Pixmap
tryxpm(Widget w, Display *dpy, char **xpm, Pixmap *pix, Pixel bg)
{
#if HAS_XPM
	XpmColorSymbol	c;
	XpmAttributes	a;
	int		status;
	Drawable	d;

	if(icons.color == NULL)
		return None;

	memset((void *)&a, '\0', sizeof(a));
	memset((void *)&c, '\0', sizeof(c));

	a.closeness  = SHRT_MAX;
	a.valuemask |= XpmCloseness;

	a.colorsymbols        = &c;
	a.numsymbols          = 1;
	a.colorsymbols->name  = "none";
	a.colorsymbols->value = NULL;
	a.colorsymbols->pixel = bg;
	a.valuemask          |= XpmColorSymbols;

	if(w == NULL) {
		d = RootWindow(dpy, DefaultScreen(dpy));
	}
	else {
		dpy = XtDisplay(w);
		d   = XtWindow(w);
		XtVaGetValues(wl_top(w),
			XmNvisual,	&a.visual,
			XmNdepth,	&a.depth,
			XmNcolormap,	&a.colormap,
			NULL);
		a.valuemask |= XpmVisual | XpmColormap | XpmDepth;
	}
	status = XpmCreatePixmapFromData(dpy, d, xpm, pix, NULL, &a);
	XpmFreeAttributes(&a);
	return status == Success ? *pix : None;
#else
	USEUP(w); USEUP(xpm); USEUP(bg);
	return None;
#endif
}

static Pixmap
tryxbm(Widget w, Display *dpy, char *data, int width, int height, Pixel bg)
{
	Pixel		fg    = None;
	int		depth = 0;

	if(icons.bits == NULL)
		return None;

	if(w == NULL)
		return XCreateBitmapFromData(dpy,
					RootWindow(dpy, DefaultScreen(dpy)),
					data, width, height);

	XtVaGetValues(w,
		XmNdepth,	&depth,
		XmNforeground,	&fg,
		NULL);

	return XCreatePixmapFromBitmapData(dpy, XtWindow(w), data, width,
							height, fg, bg, depth);
}

Pixmap
wl_icon(Widget w, Pixel bg)
{
	Pixmap	pix = None;

	if((pix = tryxpm(w, NULL, icons.color, &pix, bg)) != None)
		return pix;
	return tryxbm(w, XtDisplay(w), icons.bits, icons.width,icons.height,bg);
}

typedef struct {
	Boolean	b;
} SLOP;
int
wl_icons(Widget top, Pixmap *iconret, Pixmap *maskret)
{
	Pixmap		icon, mask;
	Arg		a[2];
	Cardinal	n;
	Pixel		bg;
	Display		*dpy = XtDisplay(top);
	SLOP		use_color;
	XtResource	r = {
		XwlNuseColorIcon, XwlCUseColorIcon,
		XtRBoolean, sizeof(Boolean), XtOffsetOf(SLOP, b),
		XtRImmediate, (XtPointer)True
	};

	if(icons.mask == NULL)
		return FALSE;

	XtGetApplicationResources(wl_top(top), &use_color, &r, 1, NULL, 0);

	mask = XCreateBitmapFromData(dpy, RootWindow(dpy, DefaultScreen(dpy)),
				icons.mask, icons.mwidth, icons.mheight);
	bg = WhitePixel(dpy, DefaultScreen(dpy));
	if(!use_color.b
	|| (icon = tryxpm(NULL, dpy, icons.color, &icon, bg)) == None)
		icon = tryxbm(NULL, dpy, icons.bits, icons.width,
							icons.height, bg);
	if(icon == None) {
		wl_free_pixmap(dpy, mask);
		if(iconret != NULL)
			*iconret = None;
		if(maskret != NULL)
			*maskret = None;
		return FALSE;
	}

	n = 0;
	XtSetArg(a[n], XmNiconPixmap, icon);		++n;
	if(mask != None) {
		XtSetArg(a[n], XmNiconMask, mask);	++n;
	}
	assert(ARGSANITY(a, n));
	XtSetValues(top, &a[0], n);

	if(iconret != NULL)
		*iconret = icon;
	if(maskret != NULL)
		*maskret = mask;

	return TRUE;
}

int
wl_icons_init(WL_ICONS *i)
{
	icons = *i;
	return TRUE;
}
