/*
 * version.c
 *	Version information generator for wlib.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: wlib/version.c,v 1.3 $")

#include	<stdio.h>
#include	<string.h>
#include	<sys/utsname.h>

#include	<wlib/build.h>
#include	<wlib/wlib.h>

/*
 * we could get the uname information at build time
 * by consulting uname(1) but this is easier than
 * relying on uname(1) and it tells us what the current
 * values are rather than what they were when mgv
 * was built
 */
char *
wl_version(char *s)
{
	struct utsname	uts;

	memset((void *)&uts, '\0', sizeof(uts));
	uname(&uts);
	sprintf(s,	"version    = %s %s\n"
			"OS         = %s\n"
			"cc         = %s\n"
			"defs       = %s\n"
			"warn       = %s\n"
			"opt        = %s\n"
			"incl       = %s\n"
			"ldflags    = %s\n"
			"libs       = %s\n"
			"uname      = %s %s %s, %s\n"
			"build date = %s",
			bld_verstring, bld_verstatus,
			bld_sysname,
			bld_cc,
			bld_defs,
			bld_warn,
			bld_opt,
			bld_incl,
			bld_ldflags,
			bld_libs,
			uts.sysname, uts.release, uts.version, uts.machine,
			bld_date);
	return s;
}
