/*
 * dirtysocks.h
 *	desperate attempt to work around the joy of POSIX compliance
 *	test suites (of course, POSIX, in their infinite wisdom,
 *	neglected to cover the "standard" networking code, I fart in
 *	their general direction!)
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#ifndef	WLIB_DIRTYSOCKS_H
#define	WLIB_DIRTYSOCKS_H
MU_HID(wlib_dirtysocks_h, "$Mu: wlib/wlib/dirtysocks.h,v 1.9 $")

/*
 * This header is only used by dirtysocks.c, if you are having problems
 * with that C file, try combinations of -DBUSTED_SYS_TYPES, -DFDOPEN_BY_HAND,
 * -U_POSIX_SOURCE, and -U_XOPEN_SOURCE in the defs_socket variable in
 * make/sys.XXX.mk.  All of the "real" socket work goes through the
 * functions in dirtysocks.c (this mess of lets-trick-the-standards-compliance
 * macros is the reason).
 */

/*
 * If you're having trouble with the (u_|u)(short|long|char) typedefs,
 * then added -DBUSTED_SYS_TYPES to the defs_socket variable in your
 * sys.XXX.mk file and try again.
 */
#if defined(BUSTED_SYS_TYPES)
	/*
	 * I don't understand why they couldn't just say
	 * "unsigned short", why the silly typedefs?  Why
	 * two different sets of typedefs for the same thing?
	 * Why did the east and west coasts have to fight so
	 * much?
	 */
	typedef unsigned short	u_short, ushort;
	typedef unsigned long	u_long, ulong;
	typedef unsigned char	u_char, uchar;
	typedef unsigned int	u_int, uint;
	typedef long		hostid_t;
#	define	NBBY	8	/* bits in a byte */
#endif

/*
 * If you can't get the fdopen() prototype when you have the extra
 * defines need to get the socket stuff, try adding -DFDOPEN_BY_HAND
 * to the defs_socket variable in your sys.XXX.mk file.
 */
#if defined(FDOPEN_BY_HAND)
	extern	FILE	*fdopen(int, const char *);
#endif

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>

/*
 * This is for Solaris 2.6.  Some combination of -U_POSIX_SOURCE, etc...
 * would probably get the same effect but I don't have 2.6 to test it
 * on.  This fix comes from Thanh Ma <tma@encore.com>.
 */
#if defined(_POSIX_SOURE) && defined(_XOPEN_SOURCE) && defined(sun)
	struct timeval {
		time_t	tv_sex;
		long	tv_usec;
	};
#endif

#include	<netinet/in.h>
#include	<netdb.h>

#endif
