/*
 * strdefs.h
 *	Extra resource strings for wlib.
 *
 * Copyright (C) 1997 Eric A. Howe
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#ifndef	WLIB_STRDEFS_H
#define	WLIB_STRDEFS_H
MU_HID(wlib_strdefs_h, "$Mu: wlib/wlib/strdefs.h,v 1.14 $")

extern const char wl_strdefs[];

/*
 * help stuff
 */
#define	XwlNhelpBrowser		((char *)&wl_strdefs[0])
#define	XwlCHelpBrowser		((char *)&wl_strdefs[12])

#define	XwlNhelpChapter		((char *)&wl_strdefs[24])
#define	XwlCHelpChapter		((char *)&wl_strdefs[36])

#define	XwlNhelpPrefix		((char *)&wl_strdefs[48])
#define	XwlCHelpPrefix		((char *)&wl_strdefs[59])

#define	XwlNhelpSection		((char *)&wl_strdefs[70])
#define	XwlCHelpSection		((char *)&wl_strdefs[82])

#define	XwlNhelpCCIPort		((char *)&wl_strdefs[94])
#define	XwlCHelpCCIPort		((char *)&wl_strdefs[106])

#define	XwlNhelpType		((char *)&wl_strdefs[118])
#define	XwlCHelpType		((char *)&wl_strdefs[127])
#define	XwlRHelpType		((char *)&wl_strdefs[136])

#define	XwlNapplicationVersion	((char *)&wl_strdefs[145])
#define	XwlCApplicationVersion	((char *)&wl_strdefs[164])

/*
 * "special" dialog resources
 */
#define	XwlNinitialFocus	((char *)&wl_strdefs[183])
#define	XwlCInitialFocus	((char *)&wl_strdefs[198])

#define	XwlNdefaultButton	((char *)&wl_strdefs[213])
#define	XwlCDefaultButton	((char *)&wl_strdefs[229])

#define	XwlNcancelButton	((char *)&wl_strdefs[245])
#define	XwlCCancelButton	((char *)&wl_strdefs[260])

/*
 * Extra representation types.
 */
#define	XwlRPercentage		((char *)&wl_strdefs[275])

/*
 * Extras for shell creation.
 */
#define	XwlNvisualClass	((char *)&wl_strdefs[286])
#define	XwlCVisualClass	((char *)&wl_strdefs[300])
#define	XwlRVisualClass	((char *)&wl_strdefs[314])

#define	XwlNvisualID	((char *)&wl_strdefs[328])
#define	XwlCVisualID	((char *)&wl_strdefs[339])
#define	XwlRVisualID	((char *)&wl_strdefs[350])

#define	XwlNdepth	((char *)&wl_strdefs[361])
#define	XwlCDepth	((char *)&wl_strdefs[369])
#define	XwlRDepth	((char *)&wl_strdefs[377])

#define	XwlNusePrivateColormap	((char *)&wl_strdefs[385])
#define	XwlCUsePrivateColormap	((char *)&wl_strdefs[406])

#define	XwlNuseColorIcon	((char *)&wl_strdefs[427])
#define	XwlCUseColorIcon	((char *)&wl_strdefs[442])

/*
 * strings
 */
#define	XwlNstringBadVersion	((char *)&wl_strdefs[457])
#define	XwlCStringBadVersion	((char *)&wl_strdefs[474])

#define	XwlNstringCantBrowse	((char *)&wl_strdefs[491])
#define	XwlCStringCantBrowse	((char *)&wl_strdefs[508])

#define	XwlNstringCantGetFile	((char *)&wl_strdefs[525])
#define	XwlCStringCantGetFile	((char *)&wl_strdefs[543])

#define	XwlNstringEmptyLog	((char *)&wl_strdefs[561])
#define	XwlCStringEmptyLog	((char *)&wl_strdefs[576])

#define	XwlNstringNotSupported	((char *)&wl_strdefs[591])
#define	XwlCStringNotSupported	((char *)&wl_strdefs[610])

#define	XwlNstringUnknown	((char *)&wl_strdefs[629])
#define	XwlCStringUnknown	((char *)&wl_strdefs[643])

#endif
