!***********************************************************************
! Application defaults for moxfm.
! Most of these are the defaults anyway, but they are listed here so you can
! change them if necessary.
!***********************************************************************

! Search paths for icon files
*bitmapPath: BITMAPDIR
*pixmapPath: PIXMAPDIR

! Default applications file to be loaded at startup
*mainApplicationFile: ~/.xfm/xfm-Main

! Configuration file (where the file types are specified)
*configFile: ~/.xfm/XFMRC

! Startup file (determines, which windows are opened at startup
! if none of the options -ignorestart, -appmgr, -filemgr or -dir
! are specified)
*startupFile: ~/.xfm/startup

! Device configuration file (floppies and such)
*devFile: ~/.xfm/moxfmdev

! Directory where application files are to be created
*applCfgPath: ~/.xfm/

! Magic headers configuration file (files you recognize by their header)
*magicFile: ~/.xfm/magic

! Autosave feature for application files
*autoSave: false

! Double click time in milliseconds
*doubleClickTime:		300

! Time interval in milliseconds for automatic folder updates (set to zero to
! disable this feature)
*updateInterval:		10000

! Set this to True, if every single file (not only the directory) shall be checked
! for changes on automatic folder updates
*checkFiles:		true

!***********************************************************************
! Preferences
!***********************************************************************

! Geometry for application and initial file manager windows
*initAppGeometry:		332x358-95+230
*initFileGeometry:		509x448+69+136
! width x height for subsequent file windows
*fileGeometry:	500x400
! width x height for subsequent application windows
*appGeometry:		300x350

! NOTE: The background color of icons is determined from the Moxfm.background
! resource. Make sure that this resource is always given a value appropriate
! for *both* application and file windows.

! The background color for file and application windows
*background: #8F5BA8F5C7AD
*menubar*background:	#91EABFFFD998
*XmTextField*background: grey
!*menubar*foreground:	black

*menubar*tearOffModel: TEAR_OFF_DISABLED

! This color is used when an icon button
! is highlighted or marked
*selectColor: red

! Specify colors for display of filenames:
*filenameColor: black
*linknameColor: maroon
! This color applies only to text display style
*textDirColor: lemon chiffon

*file window*form.highlightColor:	yellow
*file window*icon box*highlightColor:	yellow
#ifdef SGI_MODE
*sgiMode: true
*XmScrolledWindow.scrolledWindowMarginWidth: 3
*XmScrolledWindow.scrolledWindowMarginHeight: 3
#endif
! Use these only if you  have the 75dpi fonts. (recommended)
*boldFont:			-adobe-helvetica-bold-r-*-*-12-*
*iconFont:			-adobe-helvetica-medium-r-*-*-10-*
*buttonFont:			-adobe-helvetica-medium-r-*-*-12-*
*menuFont:			-adobe-helvetica-medium-r-*-*-12-*
*labelFont:			-adobe-helvetica-medium-r-*-*-12-*
*statusFont:			-adobe-helvetica-medium-r-*-*-12-*
*ttyFont:			-adobe-courier-medium-r-*-*-12-*

! This is for file names in text display mode:
*filenameFont:		-adobe-courier-medium-r-*-*-12-*

! This must be a fixed width font
*cellFont:			fixed

*XmMessageBox*fontList:	-adobe-helvetica-medium-r-*-*-12-*
*XmSelectionBox*fontList:		-adobe-helvetica-medium-r-*-*-12-*
*XmPushButtonGadget*fontList:	-adobe-helvetica-medium-r-*-*-12-*
*Popup*fontList:		-adobe-helvetica-medium-r-*-*-12-*
#ifdef SGI_MODE
!*menubar*fontList:		-adobe-helvetica-bold-r-*-*-14-*
#else
*menubar*fontList:		-adobe-helvetica-bold-r-*-*-14-*
#endif
*menubar*Pulldown*fontList:		-adobe-helvetica-bold-r-*-*-12-*

! Specify the sizes of the different icon toggles. The following values
! are appropriate for the icons supplied with xfm.
*appIconWidth: 72
*appIconHeight: 60
*fileIconWidth: 48
*fileIconHeight: 40
*treeIconWidth: 48
*treeIconHeight: 32

*Editform*XmTextField*width: 300

! Confirmation for various operations
*confirmDeletes: 		true
*confirmDeleteFolder: 		true
*confirmCopies: 		false
*confirmMoves: 			true
*confirmLinks:		false
*confirmOverwrite:		true
*confirmQuit:			true

! If you are disturbed by frequent Xt warnings (type "actions
! not found"), you might want to set this to true:
*suppressXtWarnings:	false

! Set this to true so you can see when moxfm is copying files
*showCopyInfo:		true

! Echo actions on stderr (useful for debugging purposes)
*echoActions:			false

! Directory display in Text type
*showOwner: 			true
*showDate: 			true
*showPermissions: 		true
*showLength: 			true

! Show hidden files (default):
*showHidden:			true
! Show directories first (default):
*dirsFirst:			true

! The type of the first and subsequent file windows
! valid values are Icons and Text
*initialDisplayType:	 	Icons

! The type of sorting used by default
! valid values are SortBy{Name,Size,Date}
*defaultSortType: 		SortByName

! The default editor to use
*defaultEditor: 		exec emacs

! The default viewer to use
*defaultViewer:		exec xless

! The xterm to call
*xterm:			exec xterm

*startFromXterm:		false
*keepXterm:		false

!***********************************************************************
! Miscellaneous settings (see also FmMain.c)
! Normally you won't have to change these.
!***********************************************************************

*borderWidth: 0
*DragReceiverProtocolStyle: DRAG_PREFER_PREREGISTER
