/*---------------------------------------------------------------------------
  Module FmAwActions
  
  (c) Simon Marlow 1990-92
  (c) Albert Graef 1994
  (c) Oliver Mai 1995

  Action procedures for widgets application windows
---------------------------------------------------------------------------*/

#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "Am.h"
#include "Fm.h"

/*---------------------------------------------------------------------------
  PUBLIC FUNCTIONS
---------------------------------------------------------------------------*/

int findAppItem(AppWindowRec *aw, Widget button)
{
 int i;

 for (i=0; i<aw->n_apps; i++)
 {
     if (aw->apps[i].toggle == button)  return i;
 }
 return -1;
}

/*---------------------------------------------------------------------------*/

int findAppItemByName(AppWindowRec *aw, String name)
{
 int i;

 for (i=0; i<aw->n_apps; i++)
 {
     if (aw->apps[i].name == name)  return i;
 }
 return -1;
}

/*---------------------------------------------------------------------------*/

AppWindowRec *findAppWidget(Widget w, int *i)
{
 AppWindowRec *aw;
 int j;

 for (aw = app_windows; (aw); aw = aw->next)
 {
     for (j=0; j<aw->n_apps; j++)
     {
	 if (aw->apps[j].toggle == w)
	 {
	     *i = j;
	     return aw;
	 }
     }
 }
 return NULL;
}

/*---------------------------------------------------------------------------*/

AppWindowRec *findAppWidgetByForm(Widget form)
{
 AppWindowRec *aw;

 for (aw = app_windows; (aw); aw = aw->next)
 {
     if (aw->form == form)  return aw;
 }
 return NULL;
}

/*---------------------------------------------------------------------------*/

void openApp(Widget w, Boolean newAppWin)
{
 AppWindowRec *aw;
 int i, l;
 String argv[1];
 int n_args;
 char directory[MAXPATHLEN];

 if (!(aw = findAppWidget(w, &i)))  return;
 strcpy(directory, aw->apps[i].directory);
 if (*directory)  fnexpand(directory);
 else  strcpy(directory, user.home);

 if (*aw->apps[i].push_action)
 {
     if (!strcmp(aw->apps[i].push_action, "EDIT")) doEdit(directory, aw->apps[i].fname);
     else if (!strcmp(aw->apps[i].push_action, "VIEW")) doView(directory, aw->apps[i].fname);
     else if (!strcmp(aw->apps[i].push_action, "OPEN"))
     {
        int l = strlen(directory);
	if (directory[l-1] != '/')  directory[l++] = '/';
	strcpy(directory+l, aw->apps[i].fname);
	newFileWindow(directory, NULL, NULL);
     }
     else if (!strcmp(aw->apps[i].push_action, "LOAD"))
     {
	 String newpath;

	 if (aw->blocked)  return;
	 zzz();
	 l = strlen(directory);
	 if (aw->apps[i].fname[0] == '/' || aw->apps[i].fname[0] == '~')  strcpy(directory, aw->apps[i].fname);
	 else
	 {
	     if (directory[l-1] != '/')  directory[l++] = '/';
	     strcpy(directory+l, aw->apps[i].fname);
	 }
	 fnexpand(directory);
	 newpath = (String) XtMalloc(sizeof(char) * (strlen(directory)+1));
	 strcpy(newpath, directory);
	 if (!newAppWin)
	 {
	     change_app_path_struct *data = (change_app_path_struct*) XtMalloc(sizeof (change_app_path_struct));

	     data->newpath = newpath;
	     data->aw = aw;
	     if (!resources.auto_save && aw->modified) saveDialog(aw->shell, (XtPointer) data);
	     else if (aw->modified)  changeAppProc(data, YES);
	     else changeAppProc(data, NO);
	 }
	 else
	 {
	     newApplicationWindow(newpath, NULL);
	     XTFREE(newpath);
	     wakeUp();
	 }
     }
     else
     {
	 if (aw->apps[i].fname[0])
	 {
	     n_args = 1;
	     argv[0] = XtNewString(aw->apps[i].fname);
	 }
	 else
	     n_args = 0;
	 performAction(aw->shell, aw->apps[i].icon_pm.bm, aw->apps[i].push_action, directory, n_args, argv);
     }
 }
 else error(aw->shell, "No push action defined for", aw->apps[i].name);
}

/*---------------------------------------------------------------------------*/

void runApp(Widget w, XtPointer client_data, XtPointer call_data)
{
 openApp(w, False);
}


