.TH usermount 1 "August 1995"
.SH NAME
usermount, userumount \- Filesystem mounting and unmounting utilities

.SH SYNOPSIS
.B usermount
\fIdevice\fP
.br
.B usermount
\fIdirectory\fP
.PP
.B userumount
\fIdevice\fP
.br
.B userumount
\fIdirectory\fP
.sp
.SH DESCRIPTION
Usermount and userumount enable ordinary users to mount and unmount certain filesystems. Either the special \fIdevice\fP to be (un)mounted or the correspondinng mount point \fIdirectory\fP have to be given as arguments to usermount and userumount. The file \fI/usr/local/lib/userfstab\fP determines, which devices users may mount on which mountpoints. The format of the \fIuserfstab\fP file is the same as that of \fI/etc/fstab\fP (see the manpage \fIfstab\fP(4)). A typical \fIuserfstab\fP file might look as follows:
.sp
.nf
	/dev/fd0		/floppy	msdos	defaults	0	0
	/dev/cdrom	/cdrom	iso9660	ro	0	0
.fi
.sp
This means, that users are allowed to mount the floppy drive \fI/dev/fd0\fP (with DOS formatted floppies) on the directory \fI/floppy\fP, and to mount the CD-ROM read-only on \fI/cdrom\fP. The floppy is mounted with the command \fIusermount /floppy\fP or \fIusermount /dev/fd0\fP.
.PP
When usermount and userumount have been successfull (un)mounting a device, the \fI/etc/mtab\fP file is updated accordingly. Users may only unmount those devices with userumount which they themselves mounted previously.
.PP
.B Caution:
Usermount and userumount have to be \fIsetuid root\fP in order to work. It is important that the \fIuserfstab\fP file is owned by root and not writable for any other users.
.SH "FILES"
.TP 4
.B /usr/local/lib/userfstab
Contains table of devices mountable with usermount.
.TP 4
.B /etc/mtab
Contains table of devices currently mounted with \fImount\fP or usermount.
.SH "SEE ALSO"
\fImount\fP(1), \fIfstab\fP(4), \fImoxfm(1)\fP
.SH "COPYRIGHT"
Copyright (c) 1995 by Oliver Mai
.SH "AUTHOR"
Usermount and userumount were written by Oliver Mai (mai@x4u2.desy.de) and are designed be used by the \fImoxfm\fP filemanager.
