#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include "akDoc.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akDoc::akDoc()
{
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akDoc::akDoc(string file)
	:_filename(file)
{
	readFile();
}
////////////////////////////////////////////////////////////////////////////////
//
//	akDoc copy constructor
//
////////////////////////////////////////////////////////////////////////////////
akDoc::akDoc(const akDoc& doc)
{
	_filename = doc._filename;
	_title    = doc._title;
	_sections = doc._sections;
}
////////////////////////////////////////////////////////////////////////////////
//
//	akDoc assignment operator
//
////////////////////////////////////////////////////////////////////////////////
akDoc&	akDoc::operator=(const akDoc& doc)
{
	if (this != &doc)
	  {
	   _filename = doc._filename;
	   _title    = doc._title;
	   _sections = doc._sections;
	  }
	return *this;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Reads the prescribed file and sets up the akDoc
//
////////////////////////////////////////////////////////////////////////////////
void	akDoc::readFile(void)
{
	ifstream	infile;
	char		line[BUFSIZ];
	akDocSection	*new_section;

	string		textstring;	
	string		section_title;
	string		section_text;
	int		pos1,pos2;
	bool		titleFound=false;
	bool		sectionHeaderFound=false;
	bool		sectionStartFound=false;
	int		sectionLevel=-1;

//	Open file for reading - return if error

	infile.open((char *)_filename.c_str());
	if (!infile) return;

//	Read file checking for HTML tags

	while (infile.getline(line,BUFSIZ,'\n'))
	  {

	   // Append to current string

	   textstring += line;
	   textstring += "\n";

	   // Extract document title
	
	   if (!titleFound)
	     {
	      pos1 = textstring.find("<TITLE>");
	      if (pos1 >= 0)
		{
		 pos2 = textstring.find("</TITLE>",pos1);
		 sectionHeaderFound = false;
		 sectionStartFound = false;
		}
	      else
	        pos2 = -1;
	      if (pos1 >= 0 && pos2 >= 0)
		{
		 _title.assign(textstring,pos1+7,pos2-pos1-7);
		 textstring.remove(pos1,pos2-pos1+7);
		 titleFound = true;
		}
	     }

	   // Check for section start/end

	   if (titleFound)
	     {

	      // Find start of section header

	      if (!sectionStartFound)
		{
		 int pos = textstring.find("<H1>");
		 if (pos >= 0)
		   sectionLevel = 1;
		 else
		   {
		    pos = textstring.find("<H2>");
		    if (pos >= 0)
		      sectionLevel = 2;
		    else
		      {
		       pos = textstring.find("<H3>");
		       if (pos >= 0)
		         sectionLevel = 3;
		      }
		   }
		 if (pos >= 0)
		   {
		    if (sectionHeaderFound)
		      {
		       section_text.assign(textstring,0,pos);
		       formatSection(section_text);
		       textstring.remove(0,pos);
		       new_section =
			 new akDocSection(section_title,section_text);
		       _sections.push_back(*new_section);
		       delete new_section;
		       pos1 = 0;
		      }
		    else
		      pos1 = pos;
		    sectionStartFound = true;
		    sectionHeaderFound = false;
		   }
		}

	      // Find end of section header

	      if (sectionStartFound)
		{
		 pos2 = -1;
		 if (sectionLevel == 1)
		   pos2 = textstring.find("</H1>",pos1);
		 else if (sectionLevel == 2)
		   pos2 = textstring.find("</H2>",pos1);
		 else if (sectionLevel == 3)
		   pos2 = textstring.find("</H3>",pos1);
		 if (pos2 >= 0)
		   {
		    sectionStartFound = false;
		    sectionHeaderFound = true;
		    section_title.assign(textstring,pos1+4,pos2-pos1-4);
		    textstring.remove(0,pos2+5);
		   }
		}
	     }
	  }

	// Add previous section

	if (sectionHeaderFound)
	  {
	   section_text = textstring;
	   formatSection(section_text);
	   textstring.remove();
	   new_section = new akDocSection(section_title,section_text);
	   _sections.push_back(*new_section);
	   delete new_section;
	  }

//	Close the file

	infile.close();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Removes line end tags (\n) from string
//
////////////////////////////////////////////////////////////////////////////////
void	akDoc::replaceLineEnds(string& line)
{
	int	pos;

	while ((pos = line.find("\n")) >= 0)
	  line[pos] = ' ';
}
////////////////////////////////////////////////////////////////////////////////
//
//	Format section - allow for HTML formatting tags (PRE,P)
//
////////////////////////////////////////////////////////////////////////////////
void	akDoc::formatSection(string& line)
{
	int	pos;

//	Replace <P> tags with end-of-line

	while ((pos = line.find("<P>")) >= 0)
	  {
	   line.remove(pos,3);
	   line.insert(pos,"\n");
	  }

//	Remove <PRE>,</PRE> tags

	while ((pos = line.find("<PRE>")) >= 0)
	  line.remove(pos,5);
	while ((pos = line.find("</PRE>")) >= 0)
	  line.remove(pos,6);
}
////////////////////////////////////////////////////////////////////////////////
//
//	akDocSection constructor
//
////////////////////////////////////////////////////////////////////////////////
akDocSection::akDocSection()
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	akDocSection constructor
//
////////////////////////////////////////////////////////////////////////////////
akDocSection::akDocSection(string name,string text)
	:_name(name),
	 _text(text)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	akDocSection copy constructor
//
////////////////////////////////////////////////////////////////////////////////
akDocSection::akDocSection(const akDocSection &sect)
{
	_name = sect._name;
	_text = sect._text;
}
////////////////////////////////////////////////////////////////////////////////
//
//	akDocSection assignment operator
//
////////////////////////////////////////////////////////////////////////////////
akDocSection& akDocSection::operator=(const akDocSection &sect)
{
	if (this != &sect)
	  {
	   _name = sect._name;
	   _text = sect._text;
	  }
	return *this;
}
