#include <string.h>
#include <iostream.h>
#include <stdio.h>
#include <unistd.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>

#include "akDocIcon.xpm"
#include "akDocView.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akDocView::akDocView(char *name,string file)
	: akWindow(name),
	 _sectionList((Widget)0),
	 _textArea((Widget)0),
	 _textLabel((Widget)0),
	 _currentSectionNo(0)
{
//	Create the document

	_document = new akDoc(file);

//	Construct the panel

	initialize();

	installWMClose();

//	Set the window title and icon

	setTitle(_document->title());
	setIcon("DocumentView",akDocIcon_xpm);

//	Load the section data into the document view panel

	for (int i=0;i<_document->noOfSections();i++)
	  addListItem(i);

//	Select first section

	if (_document->noOfSections() > 0)
	  selectSection(_currentSectionNo);
	else
	  {
	   XmString	temp_string;
	   temp_string = XmStringCreateLocalized("No valid document found !");
	   XtVaSetValues(_textLabel,XmNlabelString,temp_string,NULL);
	   XmStringFree(temp_string);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Panel creation function
//
////////////////////////////////////////////////////////////////////////////////
Widget 	akDocView::createWorkArea(Widget parent)
{
	Widget		form;
	Widget		messagebox;
	Widget		pane;
	Widget		list_frame,text_frame;
	Arg		args[10];

	form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,parent,0);

//	Add close button

	messagebox =
		XtVaCreateManagedWidget("MessageBox",
					xmMessageBoxWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_SYMBOL_LABEL));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_MESSAGE_LABEL));

	_closeButton =
	  new akButton(messagebox,"Button","Close",
		       &akDocView::closeCB,(XtPointer)this);
	_closeButton->manage();

//	Add a paned window to allow adjustment of list/display areas

	pane = 
	     XtVaCreateManagedWidget("DocPane",
				     xmPanedWindowWidgetClass,
				     messagebox,
				     NULL);

//	Add the section selection list

	list_frame = 
	     XtVaCreateManagedWidget("ListFrame",
				     xmFrameWidgetClass,
				     pane,
				     XmNpaneMinimum,150,
				     NULL);
	XtVaCreateManagedWidget("Sections",
				xmLabelWidgetClass,
				list_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				NULL);
	XtSetArg(args[0],XmNselectionPolicy,XmSINGLE_SELECT);
	_sectionList =
	  XmCreateScrolledList(list_frame,"DocumentList",args,1);
	XtManageChild(_sectionList);
	XtAddCallback(_sectionList,
		      XmNsingleSelectionCallback,
		      &akDocView::listItemChanged,
		      (XtPointer)this);

//	Add the text display area

	text_frame = 
	     XtVaCreateManagedWidget("DocTextFrame",
				     xmFrameWidgetClass,
				     pane,
				     NULL);
	_textLabel =
	  XtVaCreateManagedWidget("SectionTextLabel",
				  xmLabelWidgetClass,
				  text_frame,
				  XmNchildType,XmFRAME_TITLE_CHILD,
				  NULL);
	XtSetArg(args[0],XmNeditable,False);
	XtSetArg(args[1],XmNeditMode,XmMULTI_LINE_EDIT);
	XtSetArg(args[2],XmNautoShowCursorPosition,False);
	XtSetArg(args[3],XmNcursorPositionVisible,False);
	XtSetArg(args[4],XmNwordWrap,TRUE);
	_textArea =
	  XmCreateScrolledText(text_frame,"DocumentText",args,5);
	XtManageChild(_textArea);

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Close Callback.
//
////////////////////////////////////////////////////////////////////////////////
void	akDocView::closeCB(Widget,XtPointer ClientData,XtPointer)
{
	akDocView	*obj = (akDocView *)ClientData;

	obj->unmanage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Section selection mechanism
//
////////////////////////////////////////////////////////////////////////////////
void	akDocView::selectSection(int secNo)
{
//	Check for erroneous input

	if (secNo < 0 || secNo >= _document->noOfSections()) return;

//	Ensure that section is selected in list

	_currentSectionNo = secNo;
	XmListSelectPos(_sectionList,_currentSectionNo+1,FALSE);

//	Show text for selected section and update section title

	XmString	temp_string;
	XmTextSetString(_textArea,(char *)_document->sectionText(secNo).c_str());
	temp_string =
	  XmStringCreateLocalized((char *)_document->sectionName(secNo).c_str());
	XtVaSetValues(_textLabel,XmNlabelString,temp_string,NULL);
	XmStringFree(temp_string);
}
////////////////////////////////////////////////////////////////////////////////
//
//	List item changed, so update text
//
////////////////////////////////////////////////////////////////////////////////
void 	akDocView::listItemChanged(Widget,XtPointer clientData,XtPointer callData)
{
	akDocView		*obj = (akDocView *)clientData;
	XmListCallbackStruct 	*cbs = (XmListCallbackStruct *)callData;

	obj->busy();

//	If selected item differs from current then update

	if (cbs->item_position-1 != obj->_currentSectionNo)
	   obj->selectSection(cbs->item_position-1);

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Add a section to the list
//
////////////////////////////////////////////////////////////////////////////////
void	akDocView::addListItem(int secNo)
{
	XmString	section_title_string;

	if (_sectionList)
	  {
	   section_title_string =
	     XmStringCreateLocalized((char *)_document->sectionName(secNo).c_str());
	   XmListAddItem(_sectionList,section_title_string,0);
	   XmStringFree(section_title_string);
	  }
}
