#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <iostream.h>
#include "akApp.h"

#include "akHeader.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akHeader object.
//
////////////////////////////////////////////////////////////////////////////////
akHeader::akHeader(Widget parent,char *name)
	: akComponent(name)
{
	Widget		name_frame;
	Widget		name_label;
	Widget		version_frame;
	Widget		version_label;
	Widget		title_frame;
	Widget		title_label;
	Widget		clock_frame;
	char		*version_string;

//	Create form to attach components to

	_w =
		XmCreateForm(parent,_name,NULL,0);

//	Add contents of form - name, version, title, and clock

	name_frame =
		XtVaCreateManagedWidget("NameFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					NULL);
	name_label =
		XtVaCreateManagedWidget(theAkApp->applicationName().c_str(),
					xmLabelWidgetClass,
					name_frame,
					NULL);
	version_frame =
		XtVaCreateManagedWidget("VersionFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_WIDGET,
					XmNleftWidget,name_frame,
					NULL);
	version_string = new 
		char[theAkApp->applicationVersion().size())+10];
	sprintf(version_string,"Ver %s",
		theAkApp->applicationVersion().c_str());
	version_label =
		XtVaCreateManagedWidget(version_string,
					xmLabelWidgetClass,
					version_frame,
					NULL);
	delete version_string;
	clock_frame =
		XtVaCreateManagedWidget("ClockFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					NULL);
	clock = new akClock(clock_frame,"Clock");
	clock->manage();
	title_frame =
		XtVaCreateManagedWidget("TitleFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_WIDGET,
					XmNleftWidget,version_frame,
					XmNrightAttachment,XmATTACH_WIDGET,
					XmNrightWidget,clock_frame,
					NULL);
	title_label =
		XtVaCreateManagedWidget(theAkApp->applicationTitle().c_str(),
					xmLabelWidgetClass,
					title_frame,
					XmNalignment,XmALIGNMENT_BEGINNING,
					NULL);

	installDestroyHandler();

}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor function for the akHeader object.
//
////////////////////////////////////////////////////////////////////////////////
akHeader::~akHeader(void)
{
	if (clock);
	  delete clock;
}
