////////////////////////////////////////////////////////////////////////////////
//
//	Class : akHeader
//
//	Author : Andy Jefferson
//
//	Description :
//		The akHeader class provides an application header title
//		line, containing the application name, version and title
//		as well as the date/time. The akHeader object is
//		intended to be placed at the top of an applications
//		akWindow's.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akHeader_h
#define _akHeader_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akComponent.h"
#include "akClock.h"

class akHeader : public akComponent
{
	public:

		// Constructor/Destructor

		akHeader(Widget parent,char *name);
		~akHeader(void);

		// Class name

		virtual const char *const className(void)
			{return ("akHeader");}

	private:

		akClock	*clock;
};

#endif
#endif
