#include "akMessageDialogMgr.h"
#include "akApp.h"
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <assert.h>
#include <iostream.h>

akMessageDialogMgr *theAkMessageDialogMgr =
	new akMessageDialogMgr("MessageDialog");
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akMessageDialogMgr::akMessageDialogMgr(const char *name)
	:akComponent(name)
{
    // Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog generation function
//
////////////////////////////////////////////////////////////////////////////////
Widget akMessageDialogMgr::getDialog(void)
{
	Widget newDialog = NULL;

// 	If the permanent widget exists and is not in use - just return it

	if (_w && !XtIsManaged(_w))
	  return (_w);

// 	Permanent widget unavailable so create a new one (deleted later)

	newDialog = createDialog(theAkApp->baseWidget());

//	Set up callbacks for buttons

	if (newDialog != _w)
	  {
	   XtAddCallback(newDialog,XmNokCallback, 
			 &akMessageDialogMgr::actionCallback,
			 (XtPointer)this);
	   XtAddCallback(newDialog,XmNcancelCallback, 
			 &akMessageDialogMgr::actionCallback,
			 (XtPointer)this);
	   XtAddCallback(newDialog,XmNhelpCallback, 
			 &akMessageDialogMgr::actionCallback,
			 (XtPointer)this);
	  }

	if (!_w)           // If this is the first dialog to be 
	  _w = newDialog;  // created, save it to be used again

	return(newDialog);
}
////////////////////////////////////////////////////////////////////////////////
//
//	User access function
//
////////////////////////////////////////////////////////////////////////////////
Widget akMessageDialogMgr::post(akMessageDialogType type,
				 const char    *title,
				 const char    *text,
			         void          *clientData,
			         akDialogCallback ok,
			         akDialogCallback cancel,
			         akDialogCallback help)
{
	Widget	w;
	akDialogCallbackData	*old_dcd;

// 	Get a dialog widget from the cache

	Widget dialog = getDialog();

// 	Make sure the dialog exists, and that it is an XmMessageBox
// 	or subclass, since the callbacks assume these widget types

	assert (dialog);
	assert (XtIsSubclass(dialog,xmMessageBoxWidgetClass));

// 	Convert the title string to a compound string and 
// 	specify this to be the dialog title

	if (title != (char *)0)
	  {
	   XmString xmstr = XmStringCreateLtoR((char *)title,XmSTRING_DEFAULT_CHARSET);
	   XtVaSetValues(dialog,XmNdialogTitle,xmstr,NULL);
	   XmStringFree(xmstr);
	  }

// 	Convert the text string to a compound string and 
// 	specify this to be the message displayed in the dialog

	if (text != (char *)0)
	  {
	   XmString xmstr = XmStringCreateLtoR((char *)text,XmFONTLIST_DEFAULT_TAG);
	   XtVaSetValues(dialog,XmNmessageString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }

// 	Make sure that dialog is of correct type

	if (type == ERROR)
	  XtVaSetValues(dialog,XmNdialogType,XmDIALOG_ERROR,NULL);
	else if (type == WARNING)
	  XtVaSetValues(dialog,XmNdialogType,XmDIALOG_WARNING,NULL);
	else if (type == WORKING)
	  XtVaSetValues(dialog,XmNdialogType,XmDIALOG_WORKING,NULL);
	else if (type == INFORMATION)
	  XtVaSetValues(dialog,XmNdialogType,XmDIALOG_INFORMATION,NULL);
	else if (type == QUESTION)
	  XtVaSetValues(dialog,XmNdialogType,XmDIALOG_QUESTION,NULL);
	else
	  XtVaSetValues(dialog,XmNdialogType,XmDIALOG_MESSAGE,NULL);

//	Question and Working dialogs block input from application

	if (type == QUESTION || type == WORKING)
	  XtVaSetValues(dialog,XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL,
			NULL);

// 	Delete any existing callbackData (stored in XmNuserData).
//	Allocate new callbackData and store in XmNuserData.

	XtVaGetValues(dialog,XmNuserData,&old_dcd,NULL);
	if (old_dcd != (akDialogCallbackData *)0)
	  delete old_dcd;
	akDialogCallbackData *dcd =
	  new akDialogCallbackData(clientData,ok,cancel,help);
	XtVaSetValues(dialog,XmNuserData,dcd,NULL);

//	Ensure that all required buttons are available

	w = XmMessageBoxGetChild(dialog,XmDIALOG_OK_BUTTON);
	if (!ok)
	  XtUnmanageChild(w);
	else
	  XtManageChild(w);

	w = XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON);
	if (!cancel)
	  XtUnmanageChild(w);
	else
	  XtManageChild(w);

	w = XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON);
	if (!help)
	  XtUnmanageChild(w);
	else
	  XtManageChild(w);

// 	Post the dialog

	XtManageChild(dialog);
	return (dialog);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog button pressed callback
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialogMgr::actionCallback(Widget    w, 
					  XtPointer clientData,
					  XtPointer callData )
{
	XmAnyCallbackStruct	*cbs = (XmAnyCallbackStruct *) callData;
	akMessageDialogMgr	*obj = (akMessageDialogMgr *) clientData;
	akDialogCallback	callback;
	akDialogCallbackData	*dcd;

//	Extract callback data

	XtVaGetValues(w,XmNuserData,&dcd,NULL);

	callback = (akDialogCallback)0;
	switch (cbs->reason)
	  {
	   case XmCR_OK:
	      callback = dcd->ok();
	      break;
	   case XmCR_CANCEL:
	      callback = dcd->cancel();
	      break;
	   case XmCR_HELP:
	      callback = dcd->help();
	      break;
	  };

//	Call required callback

	if (callback)
          (*callback)(dcd->clientData(),callData);

//	If dialog is not the permanent one, delete it

	if (obj->baseWidget() != w)
	  {

//	   Delete callback data first

	   delete dcd;

//	   Delete dialog widget

	   XtDestroyWidget(w);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	New dialog creation function
//
////////////////////////////////////////////////////////////////////////////////
Widget	akMessageDialogMgr::createDialog(Widget parent)
{
	Widget dialog = XmCreateMessageDialog(parent,_name,NULL,0);

	return dialog;
}
