////////////////////////////////////////////////////////////////////////////////
//
//	Class : akMessageDialogMgr
//
//	Author : Andy Jefferson
//
// 	Description :
//		The akMessageDialogMgr provides a dialog
//		caching mechanism for standard dialogs.
//
//		The global instance at the foot of the header
//		is instantiated at the start of the
//		Application. It is then globally available
//		throughout the Application by including this
//		header file. As a result, to create a message dialog, just enter
//
//		dialog = theAkMessageDialogMgr(INFORMATION,
//						"A sample dialog",
//						"This is a message dialog !",
//						(XtPointer)0,
//						&myclass::mycallback);
//
//		This example creates an INFORMATION dialog with
//		only an OK button. It will be popped down when
//		the user presses the OK button - and the
//		"mycallback" function will be invoked.
//
//		Any dialogs created will have the resource name
//		"MessageDialog" - use this to set resources in a resource file.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akMessageDialogMgr_h
#define _akMessageDialogMgr_h

#ifdef __cplusplus

#include "akComponent.h"
#include "akDialogCallbackData.h"

class akMessageDialogMgr : public akComponent
{

	public:

		akMessageDialogMgr(const char *name);

		virtual Widget post(akMessageDialogType type= MESSAGE,
				    const char *title        = NULL,
				    const char *text         = NULL,
				    void *clientData         = NULL,
			  	    akDialogCallback ok     = NULL,
			  	    akDialogCallback cancel = NULL,
			  	    akDialogCallback help   = NULL);

	private:

    		Widget getDialog(void); 
		Widget createDialog(Widget);   

    		static void actionCallback(Widget,XtPointer,XtPointer);
};
extern akMessageDialogMgr *theAkMessageDialogMgr;

#endif
#endif
