#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <string.h>
#include <iostream.h>

#include "akOptionMenu.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akOptionMenu object.
//
////////////////////////////////////////////////////////////////////////////////
akOptionMenu::akOptionMenu(Widget parent,
			     char *name,
			     string prompt,
			     akOptionMenuCB callback,
			     XtPointer clientData)
	: akComponent(name),
	  _userCB(callback),
	  _userData(clientData)
{
	Widget	label=(Widget)0;
	Arg	args[3];

//	Create form to attach option menu to

	_w = XmCreateForm(parent,_name,NULL,0);
	installDestroyHandler();

//	Attach a label containing prompt (if required)

	if (prompt.size() > 0)
	  label =
		XtVaCreateManagedWidget(prompt.c_str(),
					xmLabelWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNalignment,XmALIGNMENT_END,
					NULL);

//	Set up the pulldown pane and menu

	_pane = XmCreatePulldownMenu(_w,"pane",NULL,0);
	XtSetArg(args[0],XmNsubMenuId,_pane);
	XtSetArg(args[1],XmNrightAttachment,XmATTACH_FORM);
	_menu = XmCreateOptionMenu(_w,_name,args,2);
	XtManageChild(_menu);
	if (label)
	  XtVaSetValues(_menu,
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,label,0);

//	Add the entry callback if provided

	if (_userCB)
	  XtAddCallback(_pane,
			XmNentryCallback,
			&akOptionMenu::selectionCB,
			(XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Add an option
//
////////////////////////////////////////////////////////////////////////////////
void	akOptionMenu::add(string option)
{
	XtVaCreateManagedWidget(option.c_str(),xmPushButtonWidgetClass,_pane,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remove an option
//
////////////////////////////////////////////////////////////////////////////////
void	akOptionMenu::remove(string option)
{
	Widget	*children;
	int	numChildren;

	XtVaGetValues(_pane,
		      XmNchildren,&children,
		      XmNnumChildren,&numChildren,
		      NULL);
	for (int i=0;i<numChildren;i++)
	  if (strcmp(option.c_str(),XtName(children[i])) == 0)
	    XtDestroyWidget(children[i]);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remove all options
//
////////////////////////////////////////////////////////////////////////////////
void	akOptionMenu::removeAll()
{
	Widget	*children;
	int	numChildren;

	XtVaGetValues(_pane,
		      XmNchildren,&children,
		      XmNnumChildren,&numChildren,
		      NULL);
	for (int i=0;i<numChildren;i++)
	  XtDestroyWidget(children[i]);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Select an option
//
////////////////////////////////////////////////////////////////////////////////
void	akOptionMenu::select(string option)
{
	Widget	*children;
	int	numChildren;

	XtVaGetValues(_pane,
		      XmNchildren,&children,
		      XmNnumChildren,&numChildren,
		      NULL);
	for (int i=0;i<numChildren;i++)
	  if (strcmp(option.c_str(),XtName(children[i])) == 0)
	    XtVaSetValues(_menu,XmNmenuHistory,children[i],NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selected option retrieval
//
////////////////////////////////////////////////////////////////////////////////
string	akOptionMenu::selectedOption(void)
{
	Widget	selectedWidget;
	string	selectedOption;

	selectedWidget = (Widget)0;

	XtVaGetValues(_menu,XmNmenuHistory,&selectedWidget,NULL);
	if (selectedWidget != (Widget)0)
	  selectedOption = XtName(selectedWidget);

	return selectedOption;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Option widget access function
//
////////////////////////////////////////////////////////////////////////////////
Widget	akOptionMenu::optionWidget(string option)
{
	Widget	*children;
	int	numChildren;

	XtVaGetValues(_pane,
		      XmNchildren,&children,
		      XmNnumChildren,&numChildren,
		      NULL);
	for (int i=0;i<numChildren;i++)
	  if (strcmp(option.c_str(),XtName(children[i])) == 0)
	    return children[i];
	return (Widget)0;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selection callback
//
////////////////////////////////////////////////////////////////////////////////
void	akOptionMenu::selectionCB(Widget,XtPointer clientData,XtPointer callData)
{
	akOptionMenu	*obj = (akOptionMenu *)clientData;
	XmRowColumnCallbackStruct	*cbs =
		(XmRowColumnCallbackStruct *)callData;
	string	new_selection;

	new_selection = XtName(cbs->widget);
	if (obj->_userCB)
	  obj->_userCB(obj->_userData,new_selection);
}
