#include <X11/xpm.h>
#include <Xm/Xm.h>
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include "akApp.h"
#include "akPixmap.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - XPM
//
////////////////////////////////////////////////////////////////////////////////
akPixmap::akPixmap(char **pix)
	: _pixmap((Pixmap)0),
	  _insensitive((Pixmap)0)
{
	Pixmap		the_pixmap,mask;
	XpmAttributes	attributes;
	int		status;
	Display		*display;

//	Create the pixmaps

	display = theAkApp->display();
	attributes.colormap  = theAkApp->colormap();
	attributes.closeness = 40000;
	attributes.depth     = DefaultDepth(display,DefaultScreen(display));
	attributes.visual    = DefaultVisual(display,DefaultScreen(display));
	attributes.valuemask = XpmDepth | XpmColormap | XpmVisual | XpmCloseness;
	status = XpmCreatePixmapFromData(display,
					 DefaultRootWindow(display),
					 pix,&the_pixmap,&mask,&attributes);
	if (mask) XFreePixmap(display,mask);
	if (status == XpmSuccess)
	  _pixmap = the_pixmap;
	else
	  {
	   cout << "Error creating pixmap - code=" << status << endl;
	   _pixmap = (Pixmap)0;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - XBM
//
////////////////////////////////////////////////////////////////////////////////
akPixmap::akPixmap(int pix_width,
		   int pix_height,
		   char pix_bits[])
	: _pixmap((Pixmap)0),
	  _insensitive((Pixmap)0)
{
	Display		*display;

//	Create the pixmaps

	display = theAkApp->display();
	_pixmap =
		XCreatePixmapFromBitmapData(display,
			DefaultRootWindow(display),
			pix_bits,
			pix_width,
			pix_height,
			BlackPixel(display,DefaultScreen(display)),
			WhitePixel(display,DefaultScreen(display)),
			DefaultDepth(display,DefaultScreen(display)));
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akPixmap::~akPixmap()
{
	if (_pixmap) XFreePixmap(theAkApp->display(),_pixmap);
	if (_insensitive) XFreePixmap(theAkApp->display(),_insensitive);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Insensitive Pixmap creation function
//
////////////////////////////////////////////////////////////////////////////////
void	akPixmap::createInsensitive()
{
	Dimension	width,height;
	Cardinal	depth;
	Display		*display;
	XGCValues	values;
	int		i,j;
	GC		copy_gc;
	GC		erase_gc;

//	If pixmap is NULL, return

	if (_pixmap == (Pixmap)0)
	  {
	   _insensitive = (Pixmap)0;
	   return;
	  }

//	Find pixmap extents

	extents(&width,&height,&depth);

//	Copy the pixmap

	display = theAkApp->display();
	if (width && height && depth)
	  {
	   _insensitive = XCreatePixmap(display,
				        DefaultRootWindow(display),
				        width,height,depth);
	   values.function = GXcopy;
	   copy_gc = XCreateGC(display,_insensitive,GCFunction,&values);
	   XCopyArea(display,_pixmap,_insensitive,copy_gc,0,0,width,height,0,0);
	   XFreeGC(display,copy_gc);
	  }

//	Stipple the pixmap

	int	step=7;	// Arbitrary factor for the stipple density

	values.foreground = 1;
	erase_gc = XCreateGC(display,_insensitive,GCForeground,&values);
	for (i=0;i<=height;i+=step)
	  for (j=0;j<=width;j+=step)
	    XFillRectangle(display,_insensitive,erase_gc,j,i,step/2,step/2);
	for (i=step/2;i<=(height-step/2);i+=step)
	  for (j=step/2;j<=(width-step/2);j+=step)
	    XFillRectangle(display,_insensitive,erase_gc,j,i,step/2,step/2);
	XFreeGC(display,erase_gc);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Pixmap access function
//
////////////////////////////////////////////////////////////////////////////////
Pixmap	akPixmap::pixmap()
{
	return _pixmap;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Insensitive Pixmap access function
//
////////////////////////////////////////////////////////////////////////////////
Pixmap	akPixmap::insensitive()
{
	if (!_insensitive)
	createInsensitive();
	return _insensitive;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Pixmap extents access function
//
////////////////////////////////////////////////////////////////////////////////
void	akPixmap::extents(Dimension *width,Dimension *height, Cardinal *depth)
{
	unsigned int	borderWidth;
	unsigned int	pixmapWidth;
	unsigned int	pixmapHeight;
	unsigned int	pixmapDepth;
	Window		rootWindow;
	Display		*display;
	int		x,y;

	if (_pixmap != (Pixmap)0)
	  {
	   display = theAkApp->display();
	   if (XGetGeometry(display,_pixmap,&rootWindow,&x,&y,
			    &pixmapWidth,&pixmapHeight,
			    &borderWidth,&pixmapDepth))
	     {
	      *width  = pixmapWidth;
	      *height = pixmapHeight;
	      *depth  = pixmapDepth;
	     }
	   else
	     {
	      *width  = 0;
	      *height = 0;
	      *depth  = 0;
	     }
	  }
	else
	  {
	   *width  = 0;
	   *height = 0;
	   *depth  = 0;
	  }
}
