////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPrompt
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPrompt class is an abstract class from which all
//		data entry prompts can be derived. It creates a widget
//		form, upon which are attached an optional
//		'variable name' label, together with a data entry field.
//		In addition, the data entry field's XmNactivateCallback
//		is set up to call a derived classes "changeCB" function -
//		passing the contents of the data entry field as a char string.
//
//	Public methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Label used for prompt
//		clear()			Empties the text field
//		fieldWidget()		Returns the widget of the text field
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPrompt_h
#define _akPrompt_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akComponent.h"

class akPrompt : public akComponent
{
	public:

		// Constructor/destructor

		akPrompt(Widget parent,
			  char *name,
			  string prompt);
		virtual ~akPrompt(void);

		// Class name

		virtual const char *const className(void)
			{return ("akPrompt");}

		// Access functions

		Widget		fieldWidget()
				{return (_field);}
		virtual	void	clear();
		virtual	void	setPrompt(string prompt);

	protected:

		Widget		_field;
		Widget		_label;

		// Derived classes must provide this callback function

		virtual void	changeCB(string field_string) = 0;

	private:

		static	void	promptCB(Widget w,XtPointer clientData,XtPointer callData); 
};

#endif
#endif
