////////////////////////////////////////////////////////////////////////////////
//
//	Object Name 		: akPromptDialog
//	File Name		: akPromptDialog.C
//
// DESCRIPTION:
// ------------
//	Contains the methods for the akPromptDialog class.
//
////////////////////////////////////////////////////////////////////////////////
//
// Version 1
// ---------
//	Last Author 		: Andy Jefferson
//	Date Last Changed	: Novemeber 1996
//
////////////////////////////////////////////////////////////////////////////////
#include "akPromptDialog.h"
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <assert.h>
#include <iostream.h>
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akPromptDialog::akPromptDialog(Widget parent,
				 char *name,
				 Boolean modal,
				 string prompt,
			         void  *clientData,
			         akDialogCallback ok,
			         akDialogCallback cancel,
			         akDialogCallback help)
	: akComponent(name),
	  _prompt((akPromptString *)0)
{
	Widget	button,rowcol;
	Arg	args[1];

//	Create the dialog

	if (modal)
	  {
	   XtSetArg(args[0],XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL);
	   XtSetArg(args[1],XmNautoUnmanage,false);
	   _w = XmCreateMessageDialog(parent,_name,args,2);
	  }
	else
	  {
	   XtSetArg(args[0],XmNautoUnmanage,false);
	   _w = XmCreateMessageDialog(parent,_name,args,1);
	  }
	XtUnmanageChild(XmMessageBoxGetChild(_w,XmDIALOG_MESSAGE_LABEL));
	XtUnmanageChild(XmMessageBoxGetChild(_w,XmDIALOG_SYMBOL_LABEL));

	rowcol =
		XtVaCreateManagedWidget("Rowcol",
					xmRowColumnWidgetClass,
					_w,
					XmNnumColumns,1,
					XmNpacking,XmPACK_COLUMN,
					XmNorientation,XmVERTICAL,
					0);

//	Add the prompt

	_prompt =
	  new akPromptString(rowcol,"Prompt",prompt);
	_prompt->manage();

//	Add the label

	_messageLabel =
	  new akLabel(rowcol,"PromptLabel","");
	_messageLabel->manage();

//	Set up the callback data structure

	_CBdata = new akDialogCallbackData(clientData,ok,cancel,help);

//	Ensure that all required buttons are available

	button = XmMessageBoxGetChild(_w,XmDIALOG_OK_BUTTON);
	if (!ok)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmMessageBoxGetChild(_w,XmDIALOG_CANCEL_BUTTON);
	if (!cancel)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmMessageBoxGetChild(_w,XmDIALOG_HELP_BUTTON);
	if (!help)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

//	Set up all callbacks

	XtAddCallback(_w,XmNokCallback, 
		      &akPromptDialog::actionCB,
		      (XtPointer)this);
	XtAddCallback(_w,XmNcancelCallback, 
		      &akPromptDialog::actionCB,
		      (XtPointer)this);
	XtAddCallback(_w,XmNhelpCallback, 
		      &akPromptDialog::actionCB,
		      (XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akPromptDialog::~akPromptDialog()
{
	delete _CBdata;
	if (_prompt)
	  delete _prompt;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Post function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDialog::post(void *clientData,
			      akDialogCallback ok,
			      akDialogCallback cancel,
			      akDialogCallback help)
{
	Widget	button;

//	Set up the new callback data structure

	if (_CBdata)
	  delete _CBdata;
	_CBdata = new akDialogCallbackData(clientData,ok,cancel,help);

//	Ensure that all required buttons are available

	button = XmMessageBoxGetChild(_w,XmDIALOG_OK_BUTTON);
	if (!ok)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmMessageBoxGetChild(_w,XmDIALOG_CANCEL_BUTTON);
	if (!cancel)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmMessageBoxGetChild(_w,XmDIALOG_HELP_BUTTON);
	if (!help)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	XtManageChild(_w);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set message label
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDialog::setMessageLabel(string value)
{
	_messageLabel->setLabel(value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Editable function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDialog::setEditable(bool value)
{
	XtVaSetValues(_prompt->fieldWidget(),XmNeditable,value,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Title update function
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::setTitle(string title)
{
	XmString xmstr = XmStringCreateLtoR((char *)title.c_str(),XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(_w,XmNdialogTitle,xmstr,NULL);
	XmStringFree(xmstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value update function
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::setValue(string value)
{
	_prompt->setValue(value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Prompt update function
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::setPrompt(string prompt)
{
	_prompt->setPrompt(prompt);
}
////////////////////////////////////////////////////////////////////////////////
//
//	OK Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::setOKLabel(string label)
{
	XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	XtVaSetValues(_w,XmNokLabelString,xmstr,NULL);
	XmStringFree(xmstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Cancel Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::setCancelLabel(string label)
{
	XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	XtVaSetValues(_w,XmNcancelLabelString,xmstr,NULL);
	XmStringFree(xmstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::setHelpLabel(string label)
{
	XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	XtVaSetValues(_w,XmNhelpLabelString,xmstr,NULL);
	XmStringFree(xmstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog button pressed callback
//
////////////////////////////////////////////////////////////////////////////////
void akPromptDialog::actionCB(Widget,XtPointer clientData,XtPointer callData)
{
	akPromptDialog	*obj = (akPromptDialog *)clientData;
	XmAnyCallbackStruct	*cbs = (XmAnyCallbackStruct *)callData;
	akDialogCallback	callback;

	callback = (akDialogCallback)0;
	switch (cbs->reason)
	  {
	   case XmCR_OK:
	      callback = obj->_CBdata->ok();
	      break;
	   case XmCR_CANCEL:
	      callback = obj->_CBdata->cancel();
	      break;
	   case XmCR_HELP:
	      callback = obj->_CBdata->help();
	      break;
	  };

//	Call required callback

	if (callback)
	  (*callback)(obj->_CBdata->clientData(),
		      (XtPointer)obj->_prompt->value().c_str());
}
