#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <Xm/Label.h>
#include <Xm/IconG.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>

#include "akApp.h"
#include "mxMailBoxControl.h"
#include "mxSetup.h"
#include "mxMailBoxTypes.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailBoxControl::mxMailBoxControl(Widget parent,
				   char *name,
				   string box_filename,
				   mxMailBoxType type,
				   mxMailAddressBook *book,
				   mxMailSpamBook *spam,
				   mxMailBoxControlCB callback,
				   XtPointer clientData)
	:akComponent(name),
	 _mailbox((mxMailBox *)0),
	 _display((mxMailBoxDisplay *)0),
	 _addressbook(book),
	 _spambook(spam),
	 _iconPixmap((akPixmap *)0),
	 _id(0),
	 _userCB(callback),
	 _userData(clientData),
	 _prevNoOfMessages(-1),
	 _prevNoOfMessagesRead(-1)
{
	Pixmap		pixmap;
	string		filename;

//	Create mailbox object

	_mailbox = new mxMailBox(box_filename,type);

//	Create icon button to represent mail-box

	if (type == INBOX)
	  _iconPixmap = new akPixmap(mxMailInbox_xpm);
	else if (type == OUTBOX)
	  _iconPixmap = new akPixmap(mxMailOutbox_xpm);
	else
	  _iconPixmap = new akPixmap(mxMailFolder_xpm);
	pixmap = _iconPixmap->pixmap();

	XmString	details[3];
	details[0] = XmStringCreateLocalized("Mailbox");
	details[1] = XmStringCreateLocalized("0");
	details[2] = XmStringCreateLocalized("0");
	_w =
		XtVaCreateManagedWidget("",
					xmIconGadgetClass,
					parent,
					XmNsmallIconPixmap,pixmap,
					XmNdetail,details,
					XmNdetailCount,3,
					NULL);
	for (int i=0;i<3;i++)
	  XmStringFree(details[i]);

	updateBoxSummaryLine(_mailbox->noOfMsgs(),
			_mailbox->noOfMsgs()-_mailbox->noOfMsgsRead());

	installDestroyHandler();

//	Start the mailbox monitor

	monitor((XtPointer)this,_id);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailBoxControl::~mxMailBoxControl()
{
	if (_id)
	  XtRemoveTimeOut(_id);
	if (_display)
	  delete _display;
	if (_mailbox)
	  delete _mailbox;
	XtVaSetValues(_w,XmNsmallIconPixmap,XmUNSPECIFIED_PIXMAP,0);
	if (_iconPixmap)
	  delete _iconPixmap;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function - update the no of messages etc
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::update()
{

//	Read all new messages and remove any SPAM if INBOX

	readAndRemoveSPAM();

//	Update with changes to the mailbox messages

	checkForNewMail(false);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Select function - the mailbox has been double clicked (selected)
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::select()
{
	int	no_messages;

//	Update the mailbox before displaying - return if empty

	update();
	no_messages = _mailbox->noOfMsgs();
	if (no_messages <= 0)
	  return;

//	Create mailbox display if not already existing

	if (!_display)
	  {
	   if (_mailbox->type() == INBOX)
	     _display =
	       new mxMailBoxDisplay("InboxDisplay",_mailbox,_addressbook,
				    _spambook,
				    &mxMailBoxControl::displayClosedCB,
				    (XtPointer)this);
	   else if (_mailbox->type() == OUTBOX)
	     _display =
	       new mxMailBoxDisplay("OutboxDisplay",_mailbox,_addressbook,
				    _spambook,
				    &mxMailBoxControl::displayClosedCB,
				    (XtPointer)this);
	   else if (_mailbox->type() == FOLDER)
	     _display =
	       new mxMailBoxDisplay("FolderDisplay",_mailbox,_addressbook,
				    _spambook,
				    &mxMailBoxControl::displayClosedCB,
				    (XtPointer)this);
	  }
	_display->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Display closed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::displayClosedCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxControl	*obj = (mxMailBoxControl *)clientData;
	int			no_messages=obj->_mailbox->noOfMsgs();

//	Check for changes to the mailbox messages

	obj->checkForNewMail(false);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Monitor function - check the mailbox contents
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::monitor(XtPointer clientData,XtIntervalId id)
{
	mxMailBoxControl *obj = (mxMailBoxControl *)clientData;
	int		new_no_messages;

//	If new messages, read in and remove any SPAM (if INBOX)

	new_no_messages = obj->_mailbox->noOfMsgsLatest();
	if (new_no_messages > obj->_prevNoOfMessages &&
	    obj->_prevNoOfMessages >= 0 &&
	    obj->_mailbox->type() == INBOX)
	   {
	    // Remove any SPAM from new messages
	    obj->readAndRemoveSPAM();

	    // Make sure that new no of messages is reflected
	    new_no_messages = obj->_mailbox->noOfMsgsLatest();
	   }

//	If display & no of messages changed, re-read it all and update

	if (obj->_display && new_no_messages != obj->_prevNoOfMessages)
	   {
	    obj->_mailbox->read();
	    obj->_display->update();
	   }

//	Reinstate timeout - for next check

	obj->_id =
		XtAppAddTimeOut(theAkApp->appContext(),
				(int)theMxSetup->mailUpdateInterval()*1000,
				(XtTimerCallbackProc)&mxMailBoxControl::monitor,
				(XtPointer)clientData);

//	Update with changes to mailbox messages

	obj->checkForNewMail(true);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update messages title line
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::updateBoxSummaryLine(int nmessages,int nunread)
{
	XmString	details[3];
	char		title[100];

	if (_mailbox->type() == INBOX)
	  details[0] = XmStringCreateLocalized("INBOX");
	else if (_mailbox->type() == OUTBOX)
	  details[0] = XmStringCreateLocalized("OUTBOX");
	else
	   {
	    string	temp_filename=_mailbox->filename();
	    int pos = temp_filename.rfind("/");
	    if (pos >= 0)
	      temp_filename.remove(0,pos+1);
	    details[0] = XmStringCreateLocalized((char *)temp_filename.c_str());
	   }
	sprintf(title,"%d",nmessages);
	details[1] = XmStringCreateLocalized(title);
	sprintf(title,"%d",nunread);
	details[2] = XmStringCreateLocalized(title);
	XtVaSetValues(_w,XmNdetail,details,XmNdetailCount,3,0);
	for (int i=0;i<3;i++)
	  XmStringFree(details[i]);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Read mailbox and remove SPAM (if INBOX)
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::readAndRemoveSPAM()
{
	// Make note of original messages - don't remove 'old' SPAM
	vector<string>	original_message_ids;
	for (int i=0;i<_mailbox->noOfMsgs();i++)
	  original_message_ids.push_back(_mailbox->message(i).messageId());

	// Read new messages
	_mailbox->read();

	// If NULL or empty SpamBook - return now
	if (!_spambook)
	  return;
	if (_spambook->noOfSpammers() <= 0)
	  return;
	
	// If INBOX, check for and remove spammers
	if (_mailbox->type() == INBOX)
	   {
	    // Remove any spam messages if they are 'new'
	    for (int i=_mailbox->noOfMsgs()-1;i>=0;i--)
	       {
		for (int j=0;j<_spambook->noOfSpammers();j++)
		   {
		    mxMsgSummary	msg=_mailbox->message(i);

		    if (msg.mailid() == _spambook->spammer(j))
		       {
			bool	original_message = false;
			for (int k=0;k<original_message_ids.size();k++)
			   {
			    if (msg.messageId() == original_message_ids[k])
			       {
				original_message = true;
				break;
			       }
			   }
			if (!original_message)
			  _mailbox->remove(i);
		       }
		   }
	       }

	    // Write mailbox back without spam
	    _mailbox->write();
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	New mail check
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxControl::checkForNewMail(bool update_if_no_changes)
{
	bool	new_mail=false;
	int	new_no_messages;
	int	new_no_messages_read;

//	Extract the no of messages in the mailbox
//	Use current msgs in box if got a display, else use the actual

	if (_display)
	   {
	    new_no_messages      = _mailbox->noOfMsgs();
	    new_no_messages_read = _mailbox->noOfMsgsRead();
	   }
	else
	   {
	    new_no_messages      = _mailbox->noOfMsgsLatest();
	    new_no_messages_read = _mailbox->noOfMsgsLatestRead();
	   }

//	Update status label

	if (new_no_messages != _prevNoOfMessages ||
            new_no_messages_read != _prevNoOfMessagesRead)
	  updateBoxSummaryLine(new_no_messages,
			new_no_messages-new_no_messages_read);

//	Set indicator for new mail

	if (new_no_messages > _prevNoOfMessages && _prevNoOfMessages >= 0)
	  new_mail = true;

//	Call users callback (if required)

	if (_userCB)
	   {
	    if (update_if_no_changes || new_no_messages != _prevNoOfMessages)
	      _userCB(_userData,(XtPointer)this,new_mail);
	   }

	_prevNoOfMessages = new_no_messages;
	_prevNoOfMessagesRead = new_no_messages_read;
}
