////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailLogo
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailLogo represents the logo on the main panel.
//		It manages an array of pixmaps, and allows animation of
//		a). New Mail arriving
//		b). Mail check with no new mail
//		Accompanying the animation types are associated audio sounds.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget
//			name		Name used for resource specification.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailLogo_h
#define mxMailLogo_h
#ifdef __cplusplus

#include <vector.h>
#include <std/string.h>
#include "akComponent.h"
#include "akPixmap.h"
#include "akLabel.h"
#include "akSound.h"

class mxMailLogo : public akComponent
{
	public:

		// Constructor,destructor

		mxMailLogo(Widget parent,char *name);
		~mxMailLogo();

		// Utility functions

		void	animate(bool new_mail);

	private:

		// Component widgets/methods

		akLabel			*_logo;

		akSound			*_newMailSound;
		akSound			*_checkMailSound;

		int			_animateLogoNo;
		XtIntervalId		_animationId;
		akPixmap		*_logoPixmaps[36];

		static void		animateMailCB(XtPointer,XtIntervalId*);
		static void		animateNoMailCB(XtPointer,XtIntervalId*);
};

#endif
#endif
