////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxNet
//
//	Author : Andy Jefferson
//
//	Description :
//		mxNet is the main window class for the mxNet application.
//		It controls the connection to and options used whilst
//		connected to the Internet.
//
//	Public Methods :
//		(Constructor) requires :-
//			name		Name used for resource specification.
//
//	Limitations :
//		Linked in with mxSetup item, so relies on there being a global
//		mxSetup object.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxNet_h
#define mxNet_h
#ifdef __cplusplus

#include <vector.h>
#include <std/string.h>
#include <bool.h>
#include "akWindow.h"
#include "akLabel.h"
#include "akClock.h"
#include "akButton.h"
#include "akDocView.h"
#include "akProcess.h"
#include "akSound.h"
#include "akCopyright.h"
#include "akMessageArea.h"
#include "akMessageDialog.h"
#include "mxMail.h"
#include "mxFtp.h"

class mxNet : public akWindow
{
	public:

		// Constructor,destructor

		mxNet(char *name);
		~mxNet();

	private:

		// Data used within Net process

		akProcess		*_connectionProcess;
		string			_dipConnectFile;
		string			_dipConnectText;
		bool			_connected;

		// Panel widgets/methods

		Widget			createWorkArea(Widget parent);
		Widget			createMenuBar(Widget parent);
		Widget			createToolBar(Widget parent);
		akLabel			*_applicationLogo;
		akMessageArea		*_message;
		akDocView		*_helpDocument;
		akClock			*_date;
		akClock			*_time;
		akButton		*_connectOption;
		akButton		*_disconnectOption;
		akButton		*_setupOption;
		akButton		*_helpOption;
		akButton		*_copyrightOption;
		akButton		*_quitOption;
		akButton		*_wwwOption;
		akButton		*_newsOption;
		akButton		*_mailOption;
		akButton		*_ftpOption;
		akButton		*_connectButton;
		akButton		*_disconnectButton;
		akButton		*_setupButton;
		akButton		*_helpButton;
		akButton		*_quitButton;
		akButton		*_wwwButton;
		akButton		*_newsButton;
		akButton		*_mailButton;
		akButton		*_ftpButton;
		akMessageDialog		*_quitDialog;
		akCopyright		*_copyright;
		mxMail			*_mailWindow;
		mxFtp			*_ftpWindow;

		// Utility functions

		bool		createConnectScript(string filename);
		static	void	connectProcessOutput(XtPointer,string);

		// Function callbacks

		static	void	connectCB(Widget,XtPointer,XtPointer);
		static	void	disconnectCB(Widget,XtPointer,XtPointer);
		static	void	wwwCB(Widget,XtPointer,XtPointer);
		static	void	ftpCB(Widget,XtPointer,XtPointer);
		static	void	newsCB(Widget,XtPointer,XtPointer);
		static	void	mailCB(Widget,XtPointer,XtPointer);
		static	void	setupCB(Widget,XtPointer,XtPointer);
		static	void	helpCB(Widget,XtPointer,XtPointer);
		static	void	copyrightCB(Widget,XtPointer,XtPointer);
		static	void	quitCB(Widget,XtPointer,XtPointer);
		static	void	quitOK(XtPointer,XtPointer);
		static	void	quitCancel(XtPointer,XtPointer);

		static	void	setupChangedCB(Widget,XtPointer,XtPointer);
		static	void	mailClosedCB(Widget,XtPointer,XtPointer);
		static	void	ftpClosedCB(Widget,XtPointer,XtPointer);
};

#endif
#endif
