//////////////////////////////////////////////////////////////////////////////
// This example code is from the book:
//
// Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//    by
// Douglas Young
// Prentice Hall, 1995
// ISBN 0-13-20925507
//
// Copyright 1995 by Prentice Hall
// All Rights Reserved
//
// Permission to use, copy, modify, and distribute this software for 
// any purpose except publication and without fee is hereby granted, provided 
// that the above copyright notice appear in all copies of the software.
//
///////////////////////////////////////////////////////////////////////////////
#include "akApp.h"
#include "akWindow.h"
#include <cassert>
#include <cstdlib>
#include <iostream>

akApp *theAkApp = NULL;
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akApp::akApp(const string appClassName,
	       const string appClassVersion,
	       const string appClassTitle)
	: akComponent(appClassName.c_str()),
	 _display(0),
	 _applicationName(appClassName),
	 _applicationVersion(appClassVersion),
	 _applicationTitle(appClassTitle)
{
//	Set the global akApp pointer

	theAkApp = this;  
}
////////////////////////////////////////////////////////////////////////////////
//
//	Initialise function - initialize Xt etc
//
////////////////////////////////////////////////////////////////////////////////
void 	akApp::initialize(int *argc,char **argv)
{
	_w = XtAppInitialize(&_appContext,_applicationName.c_str(),NULL,0, 
			     argc,argv,NULL,NULL,0);

	// Extract display and colormap

	_display = XtDisplay(_w);

	XtVaGetValues(_w,XmNcolormap,&_colormap,0);

	// The akApp class is less likely to need to handle
	// "surprise" widget destruction than other classes, but
	// install a callback to be safe and consistent

	installDestroyHandler();

	// Center the shell, and make sure it isn't visible

	XtVaSetValues(_w,
		      XmNmappedWhenManaged,FALSE,
		      XmNx,DisplayWidth(_display,0)/2,
		      XmNy,DisplayHeight(_display,0)/2,
		      XmNwidth,1,
		      XmNheight,1,
		      NULL);

	// The instance name of this object was set in the akComponent 
	// constructor, before the name of the program was available
	// Free the old name and reset it to argv[0]

	if (_name)
	  delete _name;
	_name = new char[strlen(argv[0])+1];
	strcpy(_name,argv[0]);

	// Force the shell window to exist so dialogs popped up from
	// this shell behave correctly

	XtRealizeWidget(_w);

	// Initialize and manage any windows registered
	// with this application.
    
	for (int i=0;i<_windows.size();i++)
	  {
	   _windows[i]->initialize();
	   _windows[i]->manage();
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Start the event loop
//
////////////////////////////////////////////////////////////////////////////////
void akApp::handleEvents()
{
	// Just loop forever
	XtAppMainLoop(_appContext);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Register a main window
//
////////////////////////////////////////////////////////////////////////////////
void akApp::registerWindow(akWindow *window)
{
	_windows.push_back(window);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Unregister a main window
//
////////////////////////////////////////////////////////////////////////////////
void akApp::unregisterWindow(akWindow *window)
{
	int	reqd_window=-1;

	for (int i=0;i<_windows.size();i++)
	  if (window == _windows[i])
	    reqd_window = i;
	if (reqd_window >= 0)
	  _windows.erase(_windows.begin()+reqd_window);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Manage the whole application
//
////////////////////////////////////////////////////////////////////////////////
void akApp::manage()
{
	// Manage all windows, popping up iconified windows as well.
    
	for (int i=0;i<_windows.size();i++)
	  _windows[i]->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Unmanage the whole application
//
////////////////////////////////////////////////////////////////////////////////
void akApp::unmanage()
{
	// Unmanage all application windows
    
	for (int i=0;i<_windows.size();i++)
	  _windows[i]->unmanage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Iconify the whole application
//
////////////////////////////////////////////////////////////////////////////////
void 	akApp::iconify()
{
	// Iconify all top-level windows

	for (int i=0;i<_windows.size();i++)
	  _windows[i]->iconify();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set the application to busy
//
////////////////////////////////////////////////////////////////////////////////
void akApp::busy()
{
	// Sets all windows as busy (StopWatch cursor).
    
	for (int i=0;i<_windows.size();i++)
	  _windows[i]->busy();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set the application to ready
//
////////////////////////////////////////////////////////////////////////////////
void akApp::ready()
{
	// Sets all windows as ready (normal cursor).
    
	for (int i=0;i<_windows.size();i++)
	  _windows[i]->ready();
}
