#include <X11/xpm.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Protocols.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>

#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cstdarg>
#include <string>
#include "akApp.h"

#include "akCopyright.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akCopyright object
//
////////////////////////////////////////////////////////////////////////////////
akCopyright::akCopyright(Widget parent,
			 char *name,
			 char *company,
			 char *year,
			 int bit_width,int bit_height,char bit_bits[])
	: akDialog(name),
	  companyName(company),
	  copyrightYear(year)
{
	Atom		WM_DELETE_WINDOW;
	Pixmap		pixmap;

//	Create the panel

	initialize(parent,
		   this,
		   "Close",
		   &akCopyright::closeCB);

//	Add destruction mechanism for Window Manager

	XtVaSetValues(_w,XmNdeleteResponse,XmDO_NOTHING,NULL);
	WM_DELETE_WINDOW = XmInternAtom(XtDisplay(_w),"WM_DELETE_WINDOW",False);
	XmAddWMProtocolCallback(_w,WM_DELETE_WINDOW,
				&akCopyright::closeCB,(XtPointer)this);

//	Set up application pixmap

	_pixmap = new akPixmap(bit_width,bit_height,bit_bits);
	pixmap = _pixmap->pixmap();
	XtVaSetValues(app_pixmap,
		      XmNlabelType,XmPIXMAP,
		      XmNlabelPixmap,pixmap,
		      NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akCopyright object
//
//	CALLING SEQUENCE:
//	new akCopyright(Widget parent,
//			 char *name,
//			 char *company,
//			 char *year,
//			 char **pix);
//
//	where parent     is the parent widget
//	      name       is the name of the object
//	      company    is the company name
//	      year       is the copyright year
//	      pix        is the pixmap in XPM format
//
////////////////////////////////////////////////////////////////////////////////
akCopyright::akCopyright(Widget parent,
			 char *name,
			 char *company,
			 char *year,
			 char **pix)
	: akDialog(name),
	  companyName(company),
	  copyrightYear(year)
{
	Atom		WM_DELETE_WINDOW;
	Pixmap		pixmap,mask;
	Display		*display;
	XpmAttributes	attributes;
	int		status;

//	Create the panel

	initialize(parent,
		   this,
		   "Close",
		   &akCopyright::closeCB);

//	Set up application pixmap

	_pixmap = new akPixmap(pix);
	pixmap = _pixmap->pixmap();
	if (pixmap != (Pixmap)0)
	  XtVaSetValues(app_pixmap,
			XmNlabelType,XmPIXMAP,
			XmNlabelPixmap,pixmap,
			NULL);
	else
	  {
	   XmString tempstr=XmStringCreateLocalized("Pixmap");
	   XtVaSetValues(app_pixmap,
			 XmNlabelType,XmSTRING,
			 XmNlabelString,tempstr,
			 NULL);
	   XmStringFree(tempstr);
	  }

	setTitle("Copyright Notice");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akCopyright::~akCopyright()
{
	if (_pixmap != (akPixmap *)0)
	  delete _pixmap;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Create panel function
//
////////////////////////////////////////////////////////////////////////////////
Widget	akCopyright::createWorkArea(Widget parent)
{
	XmString	s1,s2,label_string;
	Widget		form,company_label,text_label;
	Widget		app_frame,app_form,app_label;
	XmFontListEntry	fontlist_entry;
	XFontStruct	*fontstruct;
	XmFontList	fontlist_1;
	XmFontList	fontlist_2;
	XmFontList	fontlist_3;
	Display		*display;
	char		*applicationString;
	char		*temp_string;

	display = XtDisplay(parent);

//	Set up fontlist for panel

	fontstruct = XLoadQueryFont(display,"*-symbol-*-24-*");
	fontlist_entry = XmFontListEntryCreate("SYMBOL_FONT",
					       XmFONT_IS_FONT,fontstruct);
	fontlist_1 = XmFontListAppendEntry(NULL,fontlist_entry);
	XmFontListEntryFree(&fontlist_entry);
	fontstruct = XLoadQueryFont(display,"*-times-bold-r-*-24-*");
	fontlist_entry = XmFontListEntryCreate("HEADING_FONT",
					       XmFONT_IS_FONT,fontstruct);
	fontlist_2 = XmFontListAppendEntry(fontlist_1,fontlist_entry);
	XmFontListEntryFree(&fontlist_entry);
	fontstruct = XLoadQueryFont(display,"*-times-*-r-*-12-*");
	fontlist_entry = XmFontListEntryCreate("TEXT_FONT",
					       XmFONT_IS_FONT,fontstruct);
	fontlist_3 = XmFontListAppendEntry(fontlist_2,fontlist_entry);
	XmFontListEntryFree(&fontlist_entry);

//	Add a from to attach contents to

	form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					parent,
					NULL);

//	Add application pixmap - pixmap added in constructor

	app_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNtopOffset,5,
					XmNleftAttachment,XmATTACH_FORM,
					XmNleftOffset,5,
					XmNrightAttachment,XmATTACH_FORM,
					XmNrightOffset,5,
					NULL);
	app_form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					app_frame,
					NULL);
	app_pixmap =
		XtVaCreateManagedWidget("Pixmap Widget",
					xmLabelWidgetClass,
					app_form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					NULL);

	applicationString = new char[theAkApp->applicationName().size()+theAkApp->applicationTitle().size()+4];
	sprintf(applicationString,"%s - %s",
		theAkApp->applicationName().c_str(),
		theAkApp->applicationTitle().c_str());
	label_string = XmStringCreateLtoR(applicationString,"HEADING_FONT");
	app_label =
		XtVaCreateManagedWidget("ApplicationName",
					xmLabelWidgetClass,
					app_form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,app_pixmap,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNlabelString,label_string,
					XmNfontList,fontlist_3,
					NULL);
	XmStringFree(label_string);
	delete applicationString;

//	Add standard copyright notice label

	s1 = XmStringCreateLtoR("\323","SYMBOL_FONT");
	temp_string = new char[strlen(companyName)+strlen(copyrightYear)+3];
	sprintf(temp_string,"%s %s",
		companyName,copyrightYear);
	s2 = XmStringCreateLtoR(temp_string,"HEADING_FONT");
	delete temp_string;
	label_string = XmStringConcat(s1,s2);
	XmStringFree(s1);
	XmStringFree(s2);
	company_label =
		XtVaCreateManagedWidget("CompanyName",
					xmLabelWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,app_frame,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNlabelString,label_string,
					XmNfontList,fontlist_3,
					NULL);
	XmStringFree(label_string);
	string	tempstr;
	tempstr  = "This program is free software; you can redistribute it and/or modify\n";
	tempstr += "it under the terms of the GNU General Public License as published by\n";
	tempstr += "the Free Software Foundation; either Version 2 of the License, or\n";
	tempstr += "(at your option) any later version.\n\n";
	tempstr += "This program is distributed in the hope that it will be useful,\n";
	tempstr += "but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
	tempstr += "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n";
	tempstr += "GNU General Public License for more details.\n\n";
	tempstr += "You should have received a copy of the GNU General Public License\n";
	tempstr += "along with this program; if not, write to the Free Software\n";
	tempstr += "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.";

	label_string = XmStringCreateLtoR((char *)tempstr.c_str(),"TEXT_FONT");
	text_label =
		XtVaCreateManagedWidget("CopyrightText",
					xmLabelWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,company_label,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNlabelString,label_string,
					XmNfontList,fontlist_3,
					NULL);
	XmStringFree(label_string);
	XmFontListFree(fontlist_3);

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Close Callback
//
////////////////////////////////////////////////////////////////////////////////
void	akCopyright::closeCB(Widget,XtPointer clientData,XtPointer)
{
	akCopyright *obj = (akCopyright *)clientData;

	obj->unmanage();
}
