////////////////////////////////////////////////////////////////////////////////
//
//	Class : akFileDialogMgr
//
//	Author : Andy Jefferson
//
//	Description :
//		The akFileDialogMgr class provides a dialog caching mechanism
//		for file selection dialogs.
//		"theAkFileDialogMgr" is instantiated at the start of the
//		Application. As a result, whenever a file selection dialog
//		is required, just enter
//
//		dialog = theAkFileDialogMgr("A file selection dialog",
//					     "*.test",
//					     (XtPointer)0,
//					     &myclass::myOKcallback,
//					     &myclass::myCANCELcallback);
//
//		This creates a File Selection dialog with OK and CANCEL buttons.
//		It will be popped down when the user presses the OK button
//		(and the "myOKcallback" function called), or when the
//		user presses the CANCEL button (and the "myCANCELcallback" function
//		called).
//		Any dialogs created will have the resource name
//		"FileDialog" - use this to set any resources via a resource file.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akFileDialogMgr_h
#define _akFileDialogMgr_h

#ifdef __cplusplus

#include "akComponent.h"
#include "akDialogCallbackData.h"

class akFileDialogMgr : public akComponent
{

	public:

		akFileDialogMgr(const char *name);

		virtual Widget post(const char *title        = NULL, 
				    const char *pattern      = NULL,
				    void *clientData         = NULL,
			  	    akDialogCallback ok     = NULL,
			  	    akDialogCallback cancel = NULL,
			  	    akDialogCallback help   = NULL);

	private:

    		Widget getDialog(); 
		Widget createDialog(Widget);   

    		static void actionCallback(Widget,XtPointer,XtPointer);
};
extern akFileDialogMgr *theAkFileDialogMgr;

#endif
#endif
