////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptDble
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptDble class provides a data entry
//		prompt for a double value. It creates a widget
//		consisting of an optional variable name label,
//		together with the actual data entry field.
//		The user can retrieve the value from the class
//		via the function "value", or use a callback
//		hook to receive updates when changes are made.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//		setValue()		Sets the value in the text field
//		value()			Returns the double value
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptDble_h
#define _akPromptDble_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>
#include "akPrompt.h"

typedef void (*akPromptDbleCB) (XtPointer clientData,double value);

class akPromptDble : public akPrompt
{
	public:

		// Constructor

		akPromptDble(Widget parent,
			      char *name,
			      string variable_name,
			      akPromptDbleCB callback=0,
			      XtPointer clientData=0);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptDble");}

		// Access functions

		virtual double	value(void);
		virtual void	setValue(double new_value);

	protected:

		akPromptDbleCB	userCB;
		XtPointer	userClientData;

		virtual void	changeCB(string field_string);
};

#endif
#endif
