////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptFile
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptFile class provides a data entry prompt
//		for a filename. It creates a widget consisting of an optional
//		variable name label, together with the actual data entry field.
//
//		Additionally, it includes a (Select...) button alongside the
//		field (on the left) to provide a file-selector - which updates
//		the field when a file is selected. The file selector defaults to
//		the directory containing the currently selected file. i.e as below
//		+-------------------------+---------+-------------------------+
//		|                         |         |                         |
//		| The prompt label        |Select...| The entry field         |
//		|                         |         |                         |
//		+-------------------------+---------+-------------------------+
//		The user can retrieve the value from the class
//		via the function "value", or use a callback
//		hook to receive updates when changes are made.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//		setValue()		Set the value in the field
//		value()			Return the field value
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptFile_h
#define _akPromptFile_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>
#include "akPrompt.h"
#include "akFileDialog.h"
#include "akButton.h"

typedef void (*akPromptFileCB) (XtPointer clientData,string value);

class akPromptFile : public akPrompt
{
	public:

		// Constructor

		akPromptFile(Widget parent,
			     char *name,
			     string variable_name,
			     akPromptFileCB callback=0,
			     XtPointer clientData=0);
		~akPromptFile(void);

		// Bubble help functions

		bool		installHelp(string help);
		void		removeHelp(void);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptFile");}

		// Access functions

		virtual	string	value(void);
		virtual	void	setValue(string new_value);

	protected:

		akPromptFileCB	_userCB;
		XtPointer	_userClientData;

		akButton	*_selectButton;

		// The user is responsible for deleting the string

		virtual void	changeCB(string field_string);

	private:

		akFileDialog	*_fileDialog;

		static	void	fileSelectCB(Widget,XtPointer,XtPointer);
		static	void	fileSelectOK(XtPointer,XtPointer);
		static	void	fileSelectCANCEL(XtPointer,XtPointer);
};
#endif

#endif
