#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>
#include <iostream>

#include "akPromptPassword.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptPassword object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptPassword::akPromptPassword(Widget parent,
				 char *name,
				 string variable_name,
				 akPromptPasswordCB callback,
				 XtPointer clientData)
	: akPromptString(parent,name,variable_name,callback,clientData)
{
//	Set up modifyVerify callback on field

	XtAddCallback(_field,XmNmodifyVerifyCallback,
		      &akPromptPassword::checkPasswordCB,(XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akPromptPassword::~akPromptPassword()
{
}
////////////////////////////////////////////////////////////////////////////////
//
//	Check password function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptPassword::checkPasswordCB(Widget,XtPointer clientData,XtPointer callData)
{
	XmTextVerifyCallbackStruct *cbs =
		(XmTextVerifyCallbackStruct *)callData;
	akPromptPassword	*obj = (akPromptPassword *)clientData;

//	Don't allow pasting (make the user type the password)
//	The only problem here is that the setValue method equates to pasting
//	of the value - disabled for now until better strategy available.

//	if (cbs->text->length > 1)
//	  {
//	   cbs->doit = FALSE;
//	   return;
//	  }

//	Backspace - so delete from here to end of string

	if (obj->_savedValue.size() > 0)
	  {
	   if (cbs->startPos < cbs->currInsert ||
	       cbs->endPos > cbs->startPos ||
	       cbs->currInsert < obj->_savedValue.size())
	     {
	      cbs->endPos = obj->_savedValue.size();
	      obj->_savedValue.erase(cbs->startPos,obj->_savedValue.size()-cbs->startPos);
	     }
	  }

//	Save any additional chars

	if (cbs->text->ptr)
	  obj->_savedValue += cbs->text->ptr;
	
//	Replace all chars with * to appear in the field

	for (int len=0;len<cbs->text->length;len++)
	  cbs->text->ptr[len] = '*';
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptPassword::changeCB(string value)
{
	string	newValue;

//	Return the saved string

	newValue = _savedValue;
	if (userCB != (akPromptStringCB)0)
	  (*userCB)(userClientData,newValue);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value retrieval function
//
////////////////////////////////////////////////////////////////////////////////
string	akPromptPassword::value(void)
{
//	Retrieve password string

	string	temp_string = _savedValue;

	return temp_string;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptPassword::setValue(string new_value)
{
	_savedValue.erase();

//	Note : don't need to save value here - catered for in checkPasswordCB
//	       which is called as a result of setting the field.

	akPromptString::setValue(new_value);
}
