#include <cstdio>
#include <string>
#include <cstdlib>
#include <ctime>
#include <sys/stat.h>
#include <iostream>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>

#include "akApp.h"
#include "mxFtpMonitor.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxFtpMonitor::mxFtpMonitor(Widget parent,
			   char *name,
			   int size,
			   string filename)
	:akDialog(name),
	 _reqdSize(size),
	 _filename(filename),
	 _filenameLabel((akLabel *)0),
	 _transferLabel((akLabel *)0),
	 _statusLabel((akLabel *)0),
	 _id(0),
	 _startTime(0)
{
//	Create the panel

	initialize(parent);
	XtUnmanageChild(XmMessageBoxGetChild(_w,XmDIALOG_SEPARATOR));
	setTitle("FTP Transfer Status");

//	Start the monitoring process

	time(&_startTime);
	checkSize((XtPointer)this,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxFtpMonitor::~mxFtpMonitor()
{
	if (_id)
	  XtRemoveTimeOut(_id);
	if (_filenameLabel)
	  delete _filenameLabel;
	if (_transferLabel)
	  delete _transferLabel;
	if (_statusLabel)
	  delete _statusLabel;
}
////////////////////////////////////////////////////////////////////////////////
//
//	unmanage - remove the timeout as well as removing the panel
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtpMonitor::unmanage()
{
	akDialog::unmanage();

	if (_id)
	  XtRemoveTimeOut(_id);
}
////////////////////////////////////////////////////////////////////////////////
//
//	change
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtpMonitor::change(int size,string filename)
{
//	Cancel existing timeout (if any)

	if (_id)
	  XtRemoveTimeOut(_id);

//	Update file details

	_filename = filename;
	_reqdSize = size;

	string	tempstr = "File : " + _filename;
	_filenameLabel->setLabel(tempstr);

//	(Re-)Start the monitoring process

	time(&_startTime);
	checkSize((XtPointer)this,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxFtpMonitor::createWorkArea(Widget parent)
{
	Widget	rowcol;

	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					parent,
					XmNorientation,XmVERTICAL,
					0);

	string	tempstr = "File : " + _filename;
	_filenameLabel =
	  new akLabel(rowcol,"Filename",tempstr);
	_filenameLabel->manage();
	_transferLabel =
	  new akLabel(rowcol,"Transfer"," ");
	_transferLabel->manage();
	_statusLabel =
	  new akLabel(rowcol,"Status"," ");
	_statusLabel->manage();

	return rowcol;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Timeout callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtpMonitor::checkSize(XtPointer clientData,XtIntervalId *id)
{
	mxFtpMonitor	*obj = (mxFtpMonitor *)clientData;
	char		temp[200];
	struct	stat	stbuf;
	int		current_size=0;
	double		transfer_percent;
	double		elapsed_time;
	time_t		current_time;
	double		transfer_rate;
	double		remaining_time;

//	Extract current size of file and elapsed time

	if (stat((char *)obj->_filename.c_str(),&stbuf) != -1)
	  current_size = stbuf.st_size;
	time(&current_time);
	elapsed_time   = difftime(current_time,obj->_startTime);
	if (elapsed_time == 0)
	  {
	   transfer_rate  = 0;
	   remaining_time = 0;
	  }
	else
	  {
	   transfer_rate  = (double)current_size/elapsed_time;
	   if (transfer_rate > 0)
	     remaining_time = (double)(obj->_reqdSize-current_size)/transfer_rate;
	   else
	     remaining_time = 0;
	  }
	transfer_percent = current_size*100/obj->_reqdSize;

//	Update the transfer and status labels

	sprintf(temp,"Required Size : %8d bytes  Transferred : %8d bytes (%5.1f %%)",
		obj->_reqdSize,current_size,transfer_percent);
	obj->_transferLabel->setLabel(temp);
	sprintf(temp,"Transfer Rate : %9.2f bytes/sec (%d secs remaining)",
		transfer_rate,(int)remaining_time);
	obj->_statusLabel->setLabel(temp);
	XmUpdateDisplay(obj->_w);

//	Reinstate the timeout (in 1 secs time)

	obj->_id =
		XtAppAddTimeOut(theAkApp->appContext(),
				1000,
				&mxFtpMonitor::checkSize,
				(XtPointer)obj);
}
