////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailAttachmentSpecify
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailAttachmentSpecify prompts for a file attachment.
//
//	Public Methods :
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _mxMailAttachmentSpecify_h
#define _mxMailAttachmentSpecify_h
#ifdef __cplusplus

#include <string>
#include "akDialog.h"
#include "akPromptFile.h"
#include "akOptionMenu.h"
#include "akRadioBox.h"
#include "mxMailAttachment.h"

typedef struct
{
	int			method;
	string			filename;
	mxMailAttachmentType	type;
	string			subtype;
} mxMailAttachCallbackStruct;

class mxMailAttachmentSpecify : public akDialog
{
	public:

		// Constructor, destructor etc

		mxMailAttachmentSpecify(Widget parent,
					char *name,
					XtCallbackProc callback,
					XtPointer clientData);
		~mxMailAttachmentSpecify();

	private:

		// Data members

		XtCallbackProc	_userCB;
		XtPointer	_userData;

		// The objects/methods comprising the panel

		akPromptFile	*_filenameField;
		akRadioBox	*_attachmentModeField;
		akOptionMenu	*_attachmentTypeField;
		Widget		createWorkArea(Widget parent);

		// Callback methods and data

		static	void	okCB(Widget,XtPointer,XtPointer);
		static	void	cancelCB(Widget,XtPointer,XtPointer);

		mxMailAttachCallbackStruct	*_callbackStruct;
};

#endif
#endif
