#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>
#include <ctime>
#include <iostream>
#include "akApp.h"

#include "akClock.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akClock object.
//
////////////////////////////////////////////////////////////////////////////////
akClock::akClock(Widget parent,char *name,akClockType type)
	: akComponent(name),
	  _type(type)
{
	Arg		args[1];

//	Create clock label widget

	XtSetArg(args[0],XmNalignment,XmALIGNMENT_BEGINNING);

	_w = XmCreateLabel(parent,_name,args,1);

	installDestroyHandler();

//	Install timeout to update time

	updateTime((XtPointer)this,(XtIntervalId)_updateId);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor function for the akClock object.
//
////////////////////////////////////////////////////////////////////////////////
akClock::~akClock(void)
{
//	Remove most recently added timeout.

	if (_updateId != (XtIntervalId)0)
	  XtRemoveTimeOut(_updateId);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update the time and reinstate callback
//
////////////////////////////////////////////////////////////////////////////////
void	akClock::updateTime(XtPointer clientData,XtIntervalId)
{
	akClock *obj	= (akClock *)clientData;
	XmString	label_string;
	time_t		the_time;
	tm		*t;
	char		time_string[100];

	obj->_updateId = 0;

//	Extract the time (display as e.g 'Fri Jun 07 08:11 1996')

	time(&the_time);
	t = localtime(&the_time);
	if (obj->_type == DATE)
	  strftime(time_string,100,"%a %b %d %Y",t);
	else if (obj->_type == TIME)
	  strftime(time_string,100,"%H:%M",t);
	else
	  strftime(time_string,100,"%a %b %d %H:%M %Y",t);

//	Set up label string

	label_string = XmStringCreateLocalized(time_string);
	XtVaSetValues(obj->_w,XmNlabelString,label_string,NULL);
	XmStringFree(label_string);
	XmUpdateDisplay(obj->_w);

//	Reinstate timeout to update time just after next change

	int	interval;

	if (obj->_type == DATE)
	  interval = ((24 - t->tm_hour)*60 + t->tm_min)*60;
	else
	  interval = 60 - t->tm_sec + 1;
	obj->_updateId =
		XtAppAddTimeOut(theAkApp->appContext(),
				interval*1000,
				(XtTimerCallbackProc)&akClock::updateTime,
				(XtPointer)clientData);
}
