////////////////////////////////////////////////////////////////////////////////
//
//	Object Name 		: akList
//	File Name		: akList.C
//
//
// DESCRIPTION:
// ------------
//	Contains the methods for the akList class.
//
////////////////////////////////////////////////////////////////////////////////
//
// Version 1
// ---------
//	Last Author 		: Andy Jefferson
//	Date Last Changed	: November 1996
//
////////////////////////////////////////////////////////////////////////////////
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#include <Xm/List.h>
#include <iostream>

#include "akList.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akList object.
//
//	CALLING SEQUENCE:
//	new akList(Widget parent,char *name,
//		    XtCallbackProc browseCallback,
//		    XtPointer browseClientData,
//		    XtCallbackProc actionCallback,
//		    XtPointer actionClientData);
//
//	where parent            is the parent widget for this panel.
//	      name              is the name of the object.
//	      browseCallback    is the callback when an item is selected
//	      browseClientData  is the data passed to the users browseCB
//	      actionCallback    is the callback when an item is actioned
//	      actionClientData  is the data passed to the users actionCB
//
////////////////////////////////////////////////////////////////////////////////
akList::akList(Widget parent,
		 char *name,
		 XtCallbackProc browseCallback,
		 XtPointer browseClientData,
		 XtCallbackProc actionCallback,
		 XtPointer actionClientData)
	: akComponent(name),
	  _userBrowseCB(browseCallback),
	  _userBrowseData(browseClientData),
	  _userActionCB(actionCallback),
	  _userActionData(actionClientData)
{
	Arg	args[4];

//	Create list widget

	XtSetArg(args[0],XmNlistSizePolicy,XmCONSTANT);
//	XtSetArg(args[1],XmNscrollBarDisplayPolicy,XmSTATIC);
	_list = XmCreateScrolledList(parent,_name,args,1);
	_w = XtParent(_list);
	XtUnmanageChild(_w);
	XtManageChild(_list);

	installDestroyHandler();

	if (_userBrowseCB != 0)
	  XtAddCallback(_list,XmNbrowseSelectionCallback,
			&akList::browseCB,(XtPointer)this);
	if (_userActionCB != 0)
	  XtAddCallback(_list,XmNdefaultActionCallback,
			&akList::actionCB,(XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Policy update function
//
////////////////////////////////////////////////////////////////////////////////
void	akList::setPolicy(akListPolicy policy)
{
	if (policy == BROWSE)
	  XtVaSetValues(_list,XmNselectionPolicy,XmBROWSE_SELECT,0);
	else if (policy == MULTIPLE)
	  XtVaSetValues(_list,XmNselectionPolicy,XmMULTIPLE_SELECT,0);
	else if (policy == EXTENDED)
	  XtVaSetValues(_list,XmNselectionPolicy,XmEXTENDED_SELECT,0);
	else
	  XtVaSetValues(_list,XmNselectionPolicy,XmSINGLE_SELECT,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Browse callback
//
////////////////////////////////////////////////////////////////////////////////
void	akList::browseCB(Widget,XtPointer clientData,XtPointer callData)
{
	akList	*obj = (akList *)clientData;

//	Call the users browse callback

	obj->_userBrowseCB(obj->_list,obj->_userBrowseData,callData);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Action callback
//
////////////////////////////////////////////////////////////////////////////////
void	akList::actionCB(Widget,XtPointer clientData,XtPointer callData)
{
	akList	*obj = (akList *)clientData;

//	Call the users action callback

	obj->_userActionCB(obj->_list,obj->_userActionData,callData);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Addition
//
////////////////////////////////////////////////////////////////////////////////
void	akList::insert(string new_item,int position)
{
	XmString	tempstr;

	tempstr = XmStringCreateLocalized((char *)new_item.c_str());
	XmListAddItem(_list,tempstr,position);
	XmStringFree(tempstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Removal - by item name
//
////////////////////////////////////////////////////////////////////////////////
void	akList::remove(string new_item)
{
	XmString	tempstr;

	tempstr = XmStringCreateLocalized((char *)new_item.c_str());
	XmListDeleteItem(_list,tempstr);
	XmStringFree(tempstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Removal - by item position
//
////////////////////////////////////////////////////////////////////////////////
void	akList::remove(int position)
{
	XmListDeletePos(_list,position);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Replace - by item name
//
////////////////////////////////////////////////////////////////////////////////
void	akList::replace(string old_item,string new_item)
{
	XmString	tempstr1;
	XmString	tempstr2;

	tempstr1 = XmStringCreateLocalized((char *)old_item.c_str());
	tempstr2 = XmStringCreateLocalized((char *)new_item.c_str());
	XmListReplaceItems(_list,&tempstr1,1,&tempstr2);
	XmStringFree(tempstr1);
	XmStringFree(tempstr2);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Selection - by item
//
////////////////////////////////////////////////////////////////////////////////
void	akList::select(string item)
{
	XmString	tempstr;
	int		item_pos;
	int		top_pos;
	int		no_visible_items;

	tempstr = XmStringCreateLocalized((char *)item.c_str());
	item_pos = XmListItemPos(_list,tempstr);
	XmListSelectItem(_list,tempstr,FALSE);
	XmStringFree(tempstr);

	// Ensure that it is displayed
	XtVaGetValues(_list,
		XmNtopItemPosition,&top_pos,
		XmNvisibleItemCount,&no_visible_items,
		0);
	if (item_pos < top_pos)
	  XtVaSetValues(_list,XmNtopItemPosition,item_pos,0);
	else if (item_pos >= top_pos+no_visible_items)
	  XtVaSetValues(_list,XmNtopItemPosition,item_pos-no_visible_items+1,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Selection - by item no
//
////////////////////////////////////////////////////////////////////////////////
void	akList::select(int position)
{
	int		top_pos;
	int		no_visible_items;

	XmListSelectPos(_list,position,FALSE);

	// Ensure that it is displayed
	XtVaGetValues(_list,
		XmNtopItemPosition,&top_pos,
		XmNvisibleItemCount,&no_visible_items,
		0);
	if (position < top_pos)
	  XtVaSetValues(_list,XmNtopItemPosition,position,0);
	else if (position >= top_pos+no_visible_items)
	  XtVaSetValues(_list,XmNtopItemPosition,position-no_visible_items+1,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return selected positions
//
////////////////////////////////////////////////////////////////////////////////
int	*akList::selectedPos()
{
	unsigned int	*posns;
	int		numPositions;
	int		*positions;

	XtVaGetValues(_list,
		      XmNselectedPositions,&posns,
		      XmNselectedPositionCount,&numPositions,
		      0);
	if (numPositions == 0)
	  return (int *)0;
	positions = new int[numPositions];
	for (int i=0;i<numPositions;i++)
	  positions[i] = posns[i];

	return positions;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return no of selected positions
//
////////////////////////////////////////////////////////////////////////////////
int	akList::noSelectedPos()
{
	int		numPositions;
	XtVaGetValues(_list,XmNselectedPositionCount,&numPositions,0);
	return numPositions;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return selected items
//
////////////////////////////////////////////////////////////////////////////////
string	*akList::selectedItems()
{
	int		numSelectedItems;
	XmString	*selectedItems;
	string		*items;
	char		*temp;

	XtVaGetValues(_list,
		      XmNselectedItems,&selectedItems,
		      XmNselectedItemCount,&numSelectedItems,
		      0);
	if (numSelectedItems == 0)
	  return (string *)0;
	items = new string[numSelectedItems];
	for (int i=0;i<numSelectedItems;i++)
	  {
	   XmStringGetLtoR(selectedItems[i],XmFONTLIST_DEFAULT_TAG,&temp);
	   items[i] = temp;
	   XtFree(temp);
	  }

	return items;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return no of selected items
//
////////////////////////////////////////////////////////////////////////////////
int	akList::noSelectedItems()
{
	int		numItems;
	XtVaGetValues(_list,XmNselectedItemCount,&numItems,0);
	return numItems;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Item Replace - by item position
//
////////////////////////////////////////////////////////////////////////////////
void	akList::replace(int position,string new_item)
{
	XmString	tempstr;

	tempstr = XmStringCreateLocalized((char *)new_item.c_str());
	XmListReplaceItemsPos(_list,&tempstr,1,position);
	XmStringFree(tempstr);
}
////////////////////////////////////////////////////////////////////////////////
//
//	List Emptying
//
////////////////////////////////////////////////////////////////////////////////
void	akList::empty()
{
	XmListDeleteAllItems(_list);
}
////////////////////////////////////////////////////////////////////////////////
//
//	List Deselection
//
////////////////////////////////////////////////////////////////////////////////
void	akList::deselectAll()
{
	XmListDeselectAllItems(_list);
}
