////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPixmap
//
//	Author : Andy Jefferson
//
//	Description :
//		akPixmap represents an X11 pixmap. It can be created from
//		either an xbm or xpm description.
//
//	Public Methods :
//		(Constructor) requires :
//			pix		XPM character represenation
//		or	pix_width	pixmap width
//			pix_height	pixmap height
//			pix_bits	XBM character representation of bits.
//		pixmap()		The X11 pixmap structure
//		insensitive()		A stippled version of the pixmap
//		extents()		Return the dimensions of the pixmap
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPixmap_h
#define _akPixmap_h
#ifdef __cplusplus

#include <Xm/Xm.h>

class akPixmap
{
	public:

		// Constructor/Destructor

		akPixmap(char **pix);
		akPixmap(int pix_width,
			  int pix_height,
			  char pix_bits[]);
		~akPixmap(void);

		// Class name

		virtual const char *const className(void)
			{return ("akPixmap");}

		// X11 Pixmap access functions

		Pixmap	pixmap(void);
		Pixmap	insensitive(void);
		void	extents(Dimension *width,
				Dimension *height,
				Cardinal *depth);

	private:

		Pixmap	_pixmap;
		Pixmap	_insensitive;

		void	createInsensitive();
};

#endif
#endif
